/*
 *
 *
 * DEEPAK BAPNA
 * November 22, 1993
 *
 * 15-881 - Assignment4-  Point-Polygon-Inside Algorithm
 * Due date: November 29, 1993
 *
 * This program constitutes problem 1 of the assignment- finding out
 * is a point lies inside a polygon or not. 
 * 
 * The graphics library used here is from "simulator"- a simulator
 * designed for 16-761: Introduction to mobile robots.
 *
 * NOTE:
 * If a point lies on an edge of polygon, it is considered to lie
 * inside. The program though specifically mentions that the point lie
 * on an edge. 
*/


#include <stdio.h>   /*Standard header files */ 
#include<math.h>
#include <ctype.h>
#include <string.h>

#define SQR(x) ((x)*(x)) /* some useful functions */
#define DIST(x1,y1,x2,y2) (sqrt(SQR((x2)-(x1)) + SQR((y2)-(y1))))

#include "matrix.h"  /* simulator files */
#include "xsimX.h"
#include "xtools.h"

xsim_window world_window;

typedef struct point1 {
  float x;
  float y;
} point;

typedef struct line1 {
  point p1;
  point p2;
} line;

typedef struct polygon1 {
  int num ;/* no. of vertices */
  point poly[300]; /*maximum no. of edges of polygon is restricted to 300 */
} polygon;

/*......................................................................*/

init_graphics()               /* setting the graphics environment */
{
float x,y,w,h;
xsim_init();

xtools_load_world_file("world.wld");

world_window = xsim_create_window("World",world_r0,world_c0,world_dr,world_dc); 
xsim_set_event_handler(world_window,xtools_event_proc);
sleep(2);

x = (world_x0+world_xf)/2.0; y = (world_y0+world_yf)/2.0;
w = (world_xf-world_x0);     h = (world_yf-world_y0);
xsim_set_viewport(world_window,x,y,w,h);
xtools_render_world();
}

/*......................................................................*/

Draw_point(p)             /* A function to draw points using simulator */
			  /* functions */
point p;
{
xtools_render_cross(p.x,p.y,0.25);
}

/*......................................................................*/

/* 
 * Routine  for edge-edge intersection - from the last assigment
*/

int ccw (p0,p1,p2)
point p0, p1, p2;
{
  int dx1, dx2, dy1, dy2;
  dx1 = p1.x - p0.x; dy1 = p1.y - p0.y;
  dx2 = p2.x - p0.x; dy2 = p2.y - p0.y;
  if (dx1 * dy2 > dy1 * dx2) return 1;
  if (dx1 * dy2 < dy1 * dx2) return -1;
  if ((dx1 * dx2 < 0) || (dy1 * dy2 < 0)) return -1;
  if ((dx1 * dx1 + dy1 * dy1) < (dx2* dx2 + dy2 * dy2)) return 1;
  return 0;
}

int intersect(l1, l2)
line l1, l2;
{
return ((ccw(l1.p1, l1.p2, l2.p1) * ccw(l1.p1, l1.p2, l2.p2)) <= 0)
	&& ((ccw(l2.p1, l2.p2, l1.p1) * ccw(l2.p1, l2.p2, l1.p2)) <= 0);
}

/* Another rountine, which takes point (instead of lines) and gives
 * intersection  
*/

int intersect_1(p1, p2, p3, p4)
point p1, p2, p3, p4;
{
return ((ccw(p1, p2, p3) * ccw(p1, p2, p4)) <= 0)
	&& ((ccw(p3, p4, p1) * ccw(p3, p4, p2)) <= 0);
}

/*......................................................................*/

int odd(x) /* check if x is odd */
int x;
{
while(x >= 2)
 x = x - 2;
return x;
}

/*......................................................................*/

/* 
 * Check to see if a p0 point lies on a line segment defined by p1 and 
 * p2
*/ 

int lies_on_line(p0,p1,p2)
point p0, p1, p2;
{
int dum;

if ((DIST(p1.x,p1.y,p0.x,p0.y) + DIST(p2.x,p2.y,p0.x,p0.y) -
     DIST(p1.x,p1.y,p2.x,p2.y)) < 0.000001 ) dum = 1;
else dum = 0;
return dum;
}

/*......................................................................*/

/* 
 * Following is the main routine which gives if a point lies inside a
 * polygon.
 * 
 * Input: Polygon, Point
 * Output: 1 if point is inside (or on the edge)
 *         0 if point lies outside the edge.
*/

int point_polygon_inside(point1,poly1)
point point1;
polygon poly1;

{
int count;
int i;
point point2; /*Define point2 such that point1 and point2 forms a line */
	      /*parallel to the x_axis */
count = 0;

point2.x = 50.0;/*some large number = limit  of the window; ideally this */
	   /*should be greater than the x_max of the polygon */
point2.y = point1.y;

poly1.poly[poly1.num].x = poly1.poly[0].x;
poly1.poly[poly1.num].y = poly1.poly[0].y;

for(i = 0; i <= (poly1.num - 1); i++){
  if(lies_on_line(point1,poly1.poly[i],poly1.poly[i+1])) {
    printf("point lies on an edge \n");
    count = 1;
    return;
  }

  else{
    if(intersect_1(poly1.poly[i],poly1.poly[i+1],point1,point2)){ 
    count = count + 1;
    if ((point1.y == poly1.poly[i].y) || (point1.y ==
					  poly1.poly[i+1].y)){ 
      if (point1.y == poly1.poly[i].y){if (poly1.poly[i].y <= poly1.poly[i+1].y)
					count = count -1; }  
      if (point1.y == poly1.poly[i+1].y){if (poly1.poly[i+1].y < poly1.poly[i].y)
					  count = count -1; } 
    }
  }
}
}

printf("%d \n",count);
return odd(count);
}

/*......................................................................*/

Draw_polygon_1(object) /* A function to draw polygons */
     polygon object;
{

  int j;  

  object.poly[object.num].x = object.poly[0].x;
  object.poly[object.num].y = object.poly[0].y;

  printf("drawing polygon \n");
  for(j = 0; j < object.num ; j++){
    xtools_render_line(object.poly[j].x,object.poly[j].y,object.poly[j+1].x,object.poly[j+1].y,xsim_black,XSIM_XOR);       
    printf("%f %f \n",object.poly[j].x,object.poly[j].y);   
  }
}


/*......................................................................*/

/* Test the above routine */

main()
{
  point p0;
  polygon tri;
  char inputline[128];
  int d,d1,i;

 init_graphics();

  printf("Number of vertices of Polygon = \n"); /* Define Polygon */
  scanf("%d",&tri.num);
  i = 0;
  for(i = 0; i < tri.num; i++)
    {
      printf("Vertices of the triangle please in form x y \n");
      scanf("%f %f",&tri.poly[i].x,&tri.poly[i].y);
    }
  Draw_polygon_1(tri); /* Draw polygon on the screen */
  while(1){
    printf("Please supply a test point \n"); /* Promp for test point */
    scanf("%f %f",&p0.x,&p0.y);
    printf("%f %f",p0.x,p0.y);
    Draw_point(p0);
    if (point_polygon_inside(p0,tri))  /* Perform */
				       /* point_polygon_inside_test */
    {
xtools_render_cross(p0.x,p0.y,0.125);
printf("yes \n");}
    else printf("no \n"); 
  }   
}

