/* 15-881 Assignment3
 * Deepak Bapna
 * November 9, 93
 * This program constitutes part 3 and 4 of the assignment-
 * representing and drawing points, line segments and polygons, and
 * implementing an edge-edge intersection routine. The edge-edge
 * intersection routine handles all special cases (it doesn't gives
 * the point of intersection).
 * 
 *
 * I am using a X-based library written by Garth to draw simple points
 * and lines.
*/

#include <stdio.h>
#include <pseudops.h>
#include<math.h>
#include <ctype.h>
#include <string.h>

typedef struct point1 {
  float x;
  float y;
} point;

typedef struct line1 {
  point p1;
  point p2;
} line;

typedef struct polygon1 {
  int num ;/* no. of vertices */
  point poly[300]; /*maximum no. of edges of polygon is restricted to 300 */
} polygon;

#define SIDE 300 /* Window Size */

/****************************************************************/

/* Routine  for edge-edge intersection */
int ccw (p0,p1,p2)
point p0, p1, p2;
{
  int dx1, dx2, dy1, dy2;
  dx1 = p1.x - p0.x; dy1 = p1.y - p0.y;
  dx2 = p2.x - p0.x; dy2 = p2.y - p0.y;
  if (dx1 * dy2 > dy1 * dx2) return 1;
  if (dx1 * dy2 < dy1 * dx2) return -1;
  if ((dx1 * dx2 < 0) || (dy1 * dy2 < 0)) return -1;
  if ((dx1 * dx1 + dy1 * dy1) < (dx2* dx2 + dy2 * dy2)) return 1;
  return 0;
}

int intersect(l1, l2)
line l1, l2;
{
return ((ccw(l1.p1, l1.p2, l2.p1) * ccw(l1.p1, l1.p2, l2.p2)) <= 0)
	&& ((ccw(l2.p1, l2.p2, l1.p1) * ccw(l2.p1, l2.p2, l1.p2)) <= 0);
}

/* Simple routine to draw polygons represented in above form */

void PSDrawPolygon(poly1)
polygon poly1;
{
int i;
 PSmoveto(poly1.poly[0].x, poly1.poly[0].y);

  for (i = 1; i < poly1.num; i++)
  PSlineto(poly1.poly[i].x,poly1.poly[i].y);
 PSlineto(poly1.poly[0].x,poly1.poly[0].y);
 PSstroke();
 PSdisplay(); 
}

/* test the above routine */

main()
{
  PSWindow win1;
  point p0, p1, p2, p3;
  line l1, l2;
  polygon tri;
  char inputline[128];
  int d,d1,i;

  PSinitialize(NULL);

  win1 = PSOpenWindow(SIDE, SIDE, 100.0, "PSdemo1");

  PSfocus(win1);          /* set attention */
  PSsetgray(PS_BLACK);    /* set drawing color */
  PSsetlinewidth(0.02);   /* set line width */

    gets(inputline);
    sscanf(inputline,"%f",&p0.x);
    gets(inputline);
    sscanf(inputline,"%f",&p0.y);
    gets(inputline);
    sscanf(inputline,"%f",&p1.x);
    gets(inputline);
    sscanf(inputline,"%f",&p1.y);
    gets(inputline);
    sscanf(inputline,"%f",&p2.x);
    gets(inputline);
    sscanf(inputline,"%f",&p2.y);
    gets(inputline);
    sscanf(inputline,"%f",&p3.x);
    gets(inputline);
    sscanf(inputline,"%f",&p3.y);
d = ccw (p0, p1 , p2);
printf ("%d \n",d);

l1.p1 = p0;
l1.p2 = p1;
l2.p1 = p2;
l2.p2 = p3; 

if (intersect(l1,l2)) printf("Intersects \n");
else printf("Does not Intersects \n"); 

   printf("give the details of the polygon \n");

    gets(inputline);
    sscanf(inputline,"%d",&tri.num);
    i = 0;
    for(i = 0; i < tri.num; i++)
      {
    gets(inputline);
    sscanf(inputline,"%f",&tri.poly[i].x);
    gets(inputline);
    sscanf(inputline,"%f",&tri.poly[i].y);} 

 PSfocus(win1);       /* set attention */
 PSidentity(); 
 PSmoveto(p0.x,p0.y);
 PSlineto(p1.x,p1.y);
 PSmoveto(p2.x,p2.y);
 PSlineto(p3.x,p3.y);
 PSstroke();
 PSdisplay(); 
 PSDrawPolygon(tri); 

 sleep(10);
}









