/* File: dict.prolog to load the tms and run the Nixon example. */

/* Load the tms code */
?- consult('tms.prolog').

/* Put the default rules into the tms.
 * Each rule has the form :
 * tms-default([<attribute>(<item>,<value>),... conditions...]).
 * <attribute> - the attribute the rule is used to infer.
 * <item> - the object the attribute value is being calculated for.
 * <value> - the value of the attribute for the item.
 * conditions - a list of predicates that calculate the value.
 * Note : words starting with an uppercase letter are variables.
 *        words starting with lower case letters are constants.
 *        lists are enclosed in "[]" and items are seperated by ","
 */

/* quakers are passifists. */
/* republicans are warhawks. */
tms-default([military(X,passifist),religion(X,quaker),nationality(X,american)]).
tms-default([military(X,warhawk),party(X,republican)]).

/* assert that Nixon is a quaker. */
?- tms-assert(religion(nixon,quaker),yes).

/* assert that Nixon is a republican. */
?- tms-assert(party(nixon,republican),yes).

/* query to find Nixon's military attitude. */
?- tms-istrue(military(nixon,X),Y,R).

/* assert that Nixon is an American */
?- tms-assert(nationality(nixon,american),yes).

/* query to find Nixon's military attitude. */
?- tms-istrue(military(nixon,X),Y,R).

/* retract that Nixon is a republican. */
?- tms-retract(party(nixon,republican),yes).

/* query to find Nixon's military attitude. */
?- tms-istrue(military(nixon,X),Y,R).

/* reassert that Nixon is a republican. */
?- tms-assert(party(nixon,republican),yes).


/* query to find Nixon's military attitude. */
?- tms-istrue(military(nixon,X),Y,R).

/* retract that Nixon is a quaker. */
?- tms-retract(religion(nixon,quaker),yes).

/* query to find Nixon's military attitude. */
?- tms-istrue(military(nixon,X),Y,R).
