/* File to load the tms and run the clyde example. */

/* Load the tms code */
?- consult('tms.prolog').

/* Put the default rules into the tms.
 * Each rule has the form :
 * tms-default([<attribute>(<item>,<value>),... conditions...]).
 * <attribute> - the attribute the rule is used to infer.
 * <item> - the object the attribute value is being calculated for.
 * <value> - the value of the attribute for the item.
 * conditions - a list of predicates that calculate the value.
 * Note : words starting with an uppercase letter are variables.
 *        words starting with lower case letters are constants.
 *        lists are enclosed in "[]" and items are seperated by ","
 */

/* Elephants are grey. */
/* Royal elephants are white */

tms-default([color(X,grey),animal(X,elephant)]).
tms-default([color(X,white),animal(X,elephant),pedigree(X,royal)]).

/* make the initial assertion that clyde is an elephant. */
?- write('tms-assert(animal(clyde,elephant),yes)'),nl.
?- tms-assert(animal(clyde,elephant),yes).

/* query the tms to find Clydes's color */
?- write('tms-istrue(color(clyde,X),Y,R)'),nl.
?- tms-istrue(color(clyde,X),Y,R).

/* assert that Clyde is a royal elephant. */
?- write('tms-assert(pedigree(clyde,royal),yes)'),nl.
?- tms-assert(pedigree(clyde,royal),yes).

/* query the tms to find Clydes's color */
?- write('tms-istrue(color(clyde,X),Y,R)'),nl.
?- tms-istrue(color(clyde,X),Y,R).

