
; The function print-array prints out the elements of a 
; two-dimensional array passed as a single argument. Adapted
; from LISP by Winston and Horn.


(defun print-array (array)
   (let ((n (array-dimension array 0))
         (m (array-dimension array 1))
        )
   (terpri)
   (do ((i 0 (+ i 1))) ((= i n))
     (do
        ((j 0 (+ j 1))) ((= j m) (terpri))
        (princ (aref array i j)) (princ '| |)
     )
   )
   )
)


; The function list-to-array converts a list into an array.
; The array should be pre-declared earlier. For example
;(list-to-array '(1 2 2 5 7 7 7 7 7 ) 8-cube) will assign
; the list elements to array 8-cube.


(defun list-to-array (state array)
         (let ((n (array-dimension array 0)) 
               (a 0)
               (m (array-dimension array 1))
               )
             (do ((i 0 (+ i 1))) ((= i n ))
                 (do ((j 0 (+ j 1))) ((= j m))
                   (setf (aref array i j ) (nth a state))                   
                   (setq a (+ a 1))
                  )
              )
         )
(print-array array)
)


; variation of previous list-to-array
; the array may not be predeclared.

(defun list-to-array1 (state array n m)
         (setq array (make-array (list n m))) 
         (let ((a 0) )
             (do ((i 0 (+ i 1))) ((= i n ))
                 (do ((j 0 (+ j 1))) ((= j m))
                   (setf (aref array i j ) (nth a state))
                   (setq a (+ a 1))
                  )
              )
         )
(print-array array)
)