; Deepak Bapna
; ID# 010-74-9317
; Assignment 1b- Bonus Problem


; The initial-idea behind the problem was cost-minimisation. A person
; has moved into a new house. He has some-stuff from old house
; (represented by list *do*) and some he don't which he wanted to buy
; (represented by *dont*). He has access to 3 malls which are at
; different distances from his house. Any of the things he need may be
; available at one or more malls at same or different prices. The idea
; was to buy all things he need at minimum price taking into account
; the cost incurred to transport to and from the mall. If the mall is
; on the way, the transportation cost is zero, but if he has to travel
; extra to mall add the transporation cost. Due to lack of time I end
; up doing a sub-problem which involves only buy the things without
; taking into account the costs. 


(setq *do* '(tv camera fridge car bicycle))
(setq *dont* '(antenna vcr film stereo pump))


; The state is represented as (where-he-is object1 object2 ...) where
; the parameter where-he-is represents the person's location- home (0)
; mall-1 (1), mall-2 (2) and mall-3 (3). object1, object2 etc. are the
; objects he wants to buy. So the initial-state iscons of '0 (he is at
; home) and *dont* as he wants to buy evrything he needs. When a
; object is bought it is replaced by 0 in state. So the final state is
; (0 0 0 ..) where first zero means that he is to be back home and the
; remaining zero means that all required objects has been bought.


(setq *initial-state* (cons '0 *dont*))
(setq *goal-state* '(0 0 0 0 0 0))


; The list av-list represents the availabiliy of different things. The
; data is stored as (object which-mall what-price transportation-cost)
; So (vcr 2 200 75) means that vcr is available in mall-2 at price of
; $200 and the transportation cost incurred will be $75.

 
(setq av-list '((vcr 2 200 75) (antenna 3 10 100) (film 1 5 25)
(pump 1 10 25) (stereo 3 300 100)))   


; The availability function combined with availability-1 function
; returns a list of malls where a given object is available.


(defun availability1 (object)
  (setq av1-list '())
  (availability object av-list)
)

(defun availability (object av-list)
  (cond ((null av-list) av1-list)
        ((equal-member object (car av-list))
          (setq av1-list (cons(car av-list) av1-list))
          (availability object (cdr av-list)))
        (t (availability object (cdr av-list)))
  )
)


; The equal-member is similar to member function except that it uses
; "equal" instead of "eq" used by member.

          
(defun equal-member (item list)
  (member-if
   #'(lambda (x) (equal x item))
   list)
)


; the function av-mall1 and av-mall together gives what required
; objects are available at given mall.

(defun av-mall1 (mall)
  (av-mall mall av1-list))

(defun av-mall (mall list)
(cond ((null list) nil)
      ((equal-member mall (car list)) t)
      (t (av-mall mall (cdr list)))
)
)


; The function av-mall2 comined above predicates to find if a given
; object is available at a particular mall.


(defun av-mall2 (object mall)
 (availability1 object)
 (av-mall1 mall)
) 


; The operators for the problem are:
; buy-object- The preconditions are that he needs the object, he
;             hasn't yet bought it and that he is in the mall where it
;             is available.
;
;go-to-mall1- If he is not already in mall-1, the operator will take
;             him to mall-1. 
;Similarly the operator go-to-mall2, go-to-mall3 and go-to-home.


(defun buy-object (state object)
 (cond ((and (av-mall2 object (car state)) (equal-member object state))
       (subst '0 object state))
       (t nil)
 )
)

(defun go-to-mall1 (state)
  (cond ((not (= (car state) 1))
          (cons '1 (cdr state))) 
        (t nil)
  )
)



(defun go-to-mall2 (state)
  (cond ((not (= (car state) 2))
          (cons '2 (cdr state))) 
        (t nil)
  )
)


(defun go-to-mall3 (state)
  (cond ((not (= (car state) 3))
          (cons '3 (cdr state))) 
        (t nil)
  )
)

(defun go-to-home (state)
  (cond ((not (= (car state) 0))
          (cons '0 (cdr state))) 
        (t nil)
  )
)

; The function goal-state-p checks if a given state is *goal-state*. 

(defun goal-state-p (state)
 (equal state *goal-state*))

; The function next-states generates all possible enxt state from a
; given state.


(defun next-states (state)
(remove nil (append
(mapcar #'(lambda (object) (buy-object state object)) *dont*)
(list (go-to-mall1 state)
(go-to-mall2 state)
(go-to-mall3 state)
(go-to-home state)))
)
)


; print-state prints a state.

(defun print-state (state) 
        (print state))
