; Deepak Bapna
; SS#: 010-74-9317
; Sept 25, 93
; Assignment 1-c (Part 1c)


; The following program implements a Manhattan-distance heuristics for
; the 8-puzzle problem. This heuristic measures the Manhattan distance
; of each tile (excluding the blank)from its final position. h' is the
; sum total of the manhattan distances of all the tiles. f' = g+ h' ->
; g is equal to number of moves it took to reach particular state and
; h' is distance as evaluated by tiles-in-place heuristic.
 
; The function near-goal just determines the criterion for sorting the
; list of open nodes. If the state is nearer to the goal-state as
; evaluated by eval-dist function, then it is positioned first in the
; list of open-nodes.

; the function abs determines the absolute value of a given number.

(defun abs (x)
   (if (< x 0) (- x) x))



(defun eval-dist (state)
(list-to-array state 8-cube)
(setq dist 0) 
(let ((n (array-dimension 8-cube 0))
         (m (array-dimension 8-cube 1))
        )
   (do ((i 0 (+ i 1))) ((= i n )(return dist))
        (do ((j 0 (+ j 1))) ((= j m ))
            (cond ( (zerop (aref 8-cube i j))
                     nil)
             (t (setq dist (+ dist (+ (abs (- i (car (pos (aref 8-cube i j)))))
				      (abs (- j (cadr( pos (aref 8-cube i j))))) 				   
                                )
                         )
             ))
             ) 
         )
   )
))


(defun pos (x) 
     (setq a (length (equal-member x *goal-state*)))
     (setq a (- 9 a))
     (setq i (truncate a 3))
     (setq j (rem a 3))
     (list i j)
)

; The function closer determines which state is closer to the
; goal-state. It doesn't yet take into accound how much step it has
; already taken.


(defun near-goal (list1 list2)
      (< 
(+ (- (length list1) 1) (eval-dist (car list1)))
(+ (- (length list2) 1) (eval-dist (car list2)))
))

