; Deepak Bapna
; SS#: 010-74-9317
; Sept 25, 93
; Assignment 1-c (Part 1b)


; The following program implements a tiles-in-place heuristics for the
; 8-puzzle problem. The heuristic counts the number of tiles that are
; out of place (h'), and uses that count as an estimate of remaining
; distance. f' = g+ h' -> g is equal to number of moves it took to
; reach particular state and h' is distance as evaluated by
; tiles-in-place heuristic. 

; The function near-goal just determines the criterion for sorting the
; list of open nodes. If the state is nearer to the goal-state as
; evaluated by eval-dist function, then it is positioned first in the
; list of open-nodes.



(defun eval-dist (state)
(list-to-array state 8-cube)
(setq dist 0) 
(let ((n (array-dimension 8-cube 0))
         (m (array-dimension 8-cube 1))
        )
   (do ((i 0 (+ i 1))) ((= i n )(return dist))
        (do ((j 0 (+ j 1))) ((= j m ))
            (cond ( (zerop (aref 8-cube i j))
                     nil)
                  (  (= (aref 8-cube i j) (aref *goal-state-cube* i
						j))
                     nil)
             (t (setq dist (+ dist 1)))

             )
         )
   )
))

(defun near-goal (list1 list2)
      (<
(+ (- (length list1) 1) (eval-dist (car list1)))
(+ (- (length list2) 1) (eval-dist (car list2)))
))


