; Deepak Bapna
; SS#: 010-74-9317
; Sept 25, 93
; Assignment 1-c


; The following program uses the best-first search algorithm to solve
; problems. It takes inputs next-states (as defined in earlier
; assignments) and eval-dist (heuristic as to which of the state
; generated by hte next-states is closer to the goal-state).


; The function equal-member is a function which determines if a given
; item belongs to a given list using equal predicate.


(defun equal-member (item list)
  (member-if 
   #'(lambda (x) (equal x item)) 
   list)
)


; The expand function takes an open node and generates the
; next-states. Then it checks each next-state if it has already been
; used. If it is repeated it removes it else adds it to the list. It
; uses the next-states from assignments 1a.

  
(defun expand (path)
   (remove-if
    #'(lambda (path) (equal-member (car path) (cdr path)))
    (mapcar #'(lambda (child) (cons child path))
            (next-states (car path)))
   )
)

; The print-list-array function prints a lsit (of lists) in a nice
; way. 

(defun print-list-array (list)
       (cond
         ((null list) nil)
         (t (print-state (car list))
            (print-list-array (cdr list))
         )
       )
)


; The function no-nodes together with nodes1 keeps track of the nodes
; that are expanded. The output is number of nodes that were expanded.
; Also a list of these nodes can be obtained by uncommenting the print
; statements in the function no-nodes.  


(defun no-nodes (list)
      (cond 
         ((null list) 
          (print "number of nodes") 
          (print (length (remove nil *closed*)))
         ; (print "The following nodes were expanded")
         ; (print-list-array (remove nil *closed*))
         )
         (t 
          (nodes1 (car list))
          (no-nodes (cdr list)))
       )
 )


(defun nodes1 (list)
       (cond
         ((null list) nil)
          ((equal-member (cadr list) *closed*)
           (nodes1 (cdr list)))

          (t  
           (setq *closed* (cons (cadr list) *closed*))
           (nodes1 (cdr list)))
      )

)


; The functions best-first and best-first1 finds a solution path using
; a best-first search procedure. Best-first initialised *closed* which
; stores the expanded nodes. It also changes the input initial-state
; into a list form as required by best-first1.


(defun best-first (start)
   (setq *closed* '())
   (best-first1 (list (list start)))
)


(defun best-first1 (*open*)
       (cond ((null *open*) nil)
             ((goal-state-p (caar *open*))
               (print-list-array (reverse (car *open*)))
               (print "total no. of moves")
               (print (- (length (car *open*)) 1))
               (terpri)
               (no-nodes *open*)
)
             (t (best-first1 (sort (append (expand (car *open*)) 
                              (cdr *open*)) #'(lambda (x y) (near-goal x y)))))               
        )
)








