; Deepak Bapna
; ID# 010-74-9317
; Assignment 1a-Jug Problem


; The problem space is represented by two coordinates:
; (x,y) -> where x represents the amount of water in
; 4 gallon jug and y represents the amount of water
; in 3 gallons jug.
; x -> {0, 1, 2, 3, 4}
; y -> {0, 1, 2, 3}


; *initial-state* denotes the starting state which
; is both the jugs are empty -> (0,0).

; *goal-state* denotes the goal state which
; is 2 gallons water in 4-gallons jug. We don't
; care for water in the 3-gallon jug.


(setq *initial-state* '(0 0))

(setq *goal-state* '((2 0) (2 1) (2 2) (2 3)))


; The functions get-x and get-y as defined below 
; are used for extracting the x and y components
; respectively from a given state. get-y is 
; particularly useful as CDR returns a list and
; get-y converts it into an atom to be used later.


(defun get-x (state)
             (car state))

(defun get-y (state)
             (car (cdr state)))


; The function state-equal tests whether the two
; input states are same. The function print-state
; prints a given state while the function 
; goal-state-p tests if a input state belongs to
; the set of goal states.


(defun state-equal (state1 state2)
        (equal state1 state2))


(defun print-state (state) 
        (print state))


(defun goal-state-p (state)
        (equal (car state) 2))


; To achieve the goal of water jug problem 8 operators are defined.
; 1.fill-x-top    -> If the 4-fallon jug is not full, it is filled 
;                    from the tap.
; 2.fill-y-top    -> If the 3-fallon jug is not full, it is filled 
;                    from the tap.
; 3.empty-x       -> If there is any water in the 4-gallon jug, it
;                    is drained.
; 4.empty-y       -> If there is any water in the 3-gallon jug, it
;                    is drained.
; 5.pour-x-y-fill -> If there is some water in 4-gallon jug and the
;                    3-gallon jug is not full, water is poured in
;                    it from the 4-gallon jug till it is filled.
;                    Ofcourse the precondition is that there should
;                    be enought water in the 4-gallon jug to fill it.
; 6.pour-y-x-fill -> If there is some water in 3-gallon jug and the
;                    4-gallon jug is not full, water is poured in
;                    it from the 3-gallon jug till it is filled.
;                    Ofcourse the precondition is that there should
;                    be enought water in the 3-gallon jug to fill it.
; 7.pour-x-y-all  -> If the 4-gallon jug is not empty, all the water
;                    from it is poured into the 3-gallon jug. The
;                    function checks that the total water in 2-jugs 
;                    before the operation is not more than 3-gallons.
; 8.pour-y-x-all  -> If the 3-gallon jug is not empty, all the water
;                    from it is poured into the 4-gallon jug. The
;                    function checks that the total water in 2-jugs 
;                    before the operation is not more than 4-gallons.
;

(defun fill-x-top (state)
        (cond 
               (( < (get-x state) 4) (list '4 (get-y state)))
               (t nil)
        )
)



(defun fill-y-top (state)
         (cond 
                (( < (get-y state) 3) (list (get-x state) '3))
                (t nil)
         )
)



(defun empty-x (state)
         (cond 
                (( > (get-x state) 0) (list '0 (get-y state)))
                (t nil)
         )
)



(defun empty-y (state)
         (cond 
                (( > (get-y state) 0 )(list (get-x state) '0))
                (t nil)
         )
)


(defun pourx-y-fill (state)
    (cond 
         ((and (> (get-x state) 0) (>= (+ (get-x state) (get-y state)) 3 ) (< (get-y state) 3)) 
                  (list (- (+ (get-x state) (get-y state)) 3) '3 )
         )
         (t nil)
   )
)



(defun poury-x-fill (state)
   (cond 
       ((and (> (get-y state) 0) (>= (+ (get-x state) (get-y state)) 4) (< (get-x state) 4))
        (list '4 (- (+ (get-x state) (get-y state)) 4))
       )
       (t nil)
    )
)



(defun pourx-y-all (state)
   (cond
        ((and (> (get-x state) 0) (<= (get-x state) 3) (<= (+ (get-x state) (get-y state)) 3))
               (list '0 (+ (get-x state) (get-y state)))
        )
        (t nil)
   )
)



(defun poury-x-all (state)
    (cond
       ((and (> (get-y state) 0) (< (get-x state) 4) (<= (+ (get-x state) (get-y state)) 4))
             (list (+ (get-x state) (get-y state)) '0))
       (t nil)
    )
)


; the function set-difference gives the difference of two
; given sets.


(defun set-difference (in out)
   (cond ((null in) nil)
         ((member (car in) out) (set-difference (cdr in) out ))
         ( t (cons (car in) (set-difference (cdr in) out)))))


; the function next-states1 returns a list of all posible next
; state from a given state.

(defun next-states (state)
  (set-difference (list (fill-x-top state)
       (fill-y-top state)
       (empty-x state)
       (empty-y state)
       (pourx-y-fill state)
       (poury-x-fill state)
       (pourx-y-all state)
       (poury-x-all state)) '(()) )
)

; the function next-states1 is essentially similar to the 
; function next-states except that it prints the output in
; a nicer form.


(defun next-states1 (state)
     (print (list '(starting state is ->) state))
     (terpri)
     (print (list '(fill-x-top gives ->) (fill-x-top state)))
     (terpri)
     (print (list '(fill-y-top gives ->) (fill-y-top state)))
     (terpri)
     (print (list '(empty-x gives ->) (empty-x state)))
     (terpri)
     (print (list '(empty-y gives ->) (empty-y state)))
     (terpri)
     (print (list '(pourx-y-fill gives ->) (pourx-y-fill state)))
     (terpri)
     (print (list '(poury-x-fill gives ->) (poury-x-fill state)))
     (terpri)
     (print (list '(pourx-y-all gives ->) (pourx-y-all state)))
     (terpri)
     (print (list '(poury-x-all gives ->) (poury-x-all state)))
     (terpri)
)





