; Deepak Bapna
; ID# 010-74-9317
; Assignment 1b

; This program uses the breadth-search method to find a solution for
; given problem. This program is generic in the sense that it can be
; used for any problem- the next-state, goal-state-p and print-state
; are to be supplied for each problem. This program is used to solve
; both the water jug problem and the 8-puzzle problem.



; The function equal-member is used in place of the "member" function.
; While the member function uses "eq" to check the condition, this
; function uses "equal" which is what we want for this program.


(defun equal-member (item list)
  (member-if 
   #'(lambda (x) (equal x item)) 
   list)
)


(defun member-open (state open-list)
    (cond
      ((null open-list) nil)
      ((equal-member state (car (cdr open-list))) t)
      (t (member-open state (cdr open-list)))
    )
)


; The expand function takes an open node and generates the
; next-states. Then it checks each next-state if it has already been
; used. If it is repeated it removes it else adds it to the list. It
; uses the next-states from assignments 1a.


(defun expand (path)
   (remove-if
    #'(lambda (path) (equal-member (car path) (cdr path)))
    (mapcar #'(lambda (child) (cons child path))
            (next-states (car path)))
   )
)


; The print-list-array function prints the result in a nice way.

(defun print-list-array (list)
       (cond
         ((null list) nil)
         (t (print-state (car list))
            (print-list-array (cdr list))
         )
       )
)


; the breadth-first function converts the initial-state into a list as
; required by the breadth1-search function which runs the search.

(defun breadth-first (start)
       (breadth1-search (list (list start))))


(defun breadth1-search (*open*)
       (cond ((null *open*) nil)
             ((goal-state-p (caar *open*))
               (print-list-array (reverse (car *open*))))
             (t (breadth1-search (append (cdr *open*) (expand (car *open*))))) 
        )
)









