; Deepak Bapna
; ID 010-74-9317
; Assignment 1a- The 8-puzzle


; The state is represented by a list of 9 numbers, each number
; representing a position on the 8-cube as below:
;                     1 2 3
;                     4 5 6
;                     7 8 9
; Example; The state (1 2 3 0 5 8 7 6 4 ) represents the following
; configuration.     
;                     1 2 3
;                     0 5 8
;                     7 6 4
; where " 0 " represents the blank space. The state in internally
; converted from a list of 9 numbers to a 3 x 3 array.


; The function array-to-list converts a given array to a simple
; list. The syntax is (array-to-list 'annu array) where
; annu is the name of required output list and array is the name
; of input array. (array-to-list 'annu 8-cube) will convert the 
; array 8-cube into a list called annu.


(defun array-to-list (state-name array)
   (setq state-name  '())
   (let ((n (array-dimension array 0))
         (m (array-dimension array 1))
        )
     (do ((i 0 (+ i 1))) ((= i n ))
        (do ((j 0 (+ j 1))) ((= j m))
         (setq state-name (cons (aref array i j) state-name))
         )
     )
     (setq state-name (reverse state-name))      
   )
)


; The function list-to-array converts a list into an array.
; The array should be pre-declared earlier. For example
;(list-to-array '(1 2 2 5 7 7 7 7 7 ) 8-cube) will assign
; the list elements to array 8-cube.


(defun list-to-array (state array)
         (let ((n (array-dimension array 0)) 
               (a 0)
               (m (array-dimension array 1))
               )
             (do ((i 0 (+ i 1))) ((= i n ))
                 (do ((j 0 (+ j 1))) ((= j m))
                   (setf (aref array i j ) (nth a state))
                   (setq a (+ a 1))
                  )
             )
         )
;(print-array array)
)



; The function print-array prints out the elements of a 
; two-dimensional array passed as a single argument. Adapted
; from LISP by Winston and Horn.


(defun print-array (array)
   (let ((n (array-dimension array 0))
         (m (array-dimension array 1))
        )
   (terpri)
   (do ((i 0 (+ i 1))) ((= i n))
     (do
        ((j 0 (+ j 1))) ((= j m) (terpri))
        (princ (aref array i j)) (princ '| |)
     )
   )
   )
)






; The function *initial-state* sets the initial state.
; Similarly the function *goal-state* sets the goal state.

(setq *initial-state* '(1 0 3 6 2 4 8 7 5))
(setq *goal-state* '(1 2 3 8 0 4 7 6 5))

(setq *initial-state-cube* (make-array '(3 3)))
(setq 8-cube (make-array '(3 3)))
(setq *goal-state-cube* (make-array '(3 3)))


(list-to-array *initial-state* *initial-state-cube* )
(list-to-array *initial-state* 8-cube)
(list-to-array *goal-state* *goal-state-cube* )


; The function state-equal tests whether the two
; input states are same. The function print-state
; prints a given state while the function 
; goal-state-p tests if a input state belongs to
; the set of goal states.


(defun state-equal (state1 state2)
        (equal state1 state2))


(defun print-state (state) 
(setq temp (make-array '(3 3)))
(list-to-array  state temp)
(print-array temp))


(defun goal-state-p (state)
(state-equal state *goal-state*))



; In order to achieve the goal for this problemm four operators
; move-up, move-down, move-left and move-right are defined.
; 1. Move-up    -> The operator moves the number below zero, up, to
;                  the zero location. Ofcourse, if the zero lies
;                  in the last row, this operator doesn't apply.
; 2. Move-down  -> The operator moves the number above zero, down to
;                  the zero location. Ofcourse, if the zero lies
;                  this operator doesn't apply.
; 3. Move-left  -> The operator moves the number right to zero, to
;                  the zero location. Ofcourse, if the zero lies
;                  in the last column, this operator doesn't apply.
; 4. Move-right -> The operator moves the number left to zero, to
;                  the zero location. Ofcourse, if the zero lies
;                  in the first column, this operator doesn't apply.


(defun move-up (array)
   (print "move-up gives ->")
   (let ((n (array-dimension array 0))
         (m (array-dimension array 1))
        )
   (do ((i 0 (+ i 1))) ((= i (- n 1) ))
        (do ((j 0 (+ j 1))) ((= j m))
            (cond 
                  ( (zerop (aref array i j))
                    (setq temp (aref array (+ i 1) j))
                    (setf (aref array (+ i 1) j ) 0) 
                    (setf (aref array i j  ) temp)
                    (setq i (- n 2))
                    (setq j (- m 1))
                    (print-array array) 
                  )
              (t nil)
        )
     )
   )   
))


(defun move-down (array)
   (print "move-down gives ->")
   (let ((n (array-dimension array 0))
         (m (array-dimension array 1))
        )
   (do ((i 1 (+ i 1))) ((= i n ))
        (do ((j 0 (+ j 1))) ((= j m))
            (cond 
                  ( (zerop (aref array i j))
                    (setq temp (aref array (- i 1) j))
                    (setf (aref array (- i 1) j ) 0) 
                    (setf (aref array i j  ) temp)
                    (setq i (- n 1))
                    (setq j (- m 1)) 
                    (print-array array)
                  )
              (t nil) 
        )
     )
   )   
))


(defun move-left (array)
   (print "move-left gives ->")
   (let ((n (array-dimension array 0))
         (m (array-dimension array 1))
        )
   (do ((i 0 (+ i 1))) ((= i n ))
        (do ((j 0 (+ j 1))) ((= j (- m 1)))
            (cond 
                  ( (zerop (aref array i j))
                    (setq temp (aref array i (+ j 1)))
                    (setf (aref array i(+ j 1)) 0) 
                    (setf (aref array i j  ) temp)
                    (setq i (- n 1))
                    (setq j (- m 2)) 
                    (print-array array)
                  )
              (t nil) 
        )
     )
   )   
))



(defun move-right (array)
   (print "move-right gives ->")
   (let ((n (array-dimension array 0))
         (m (array-dimension array 1))
        )
   (do ((i 0 (+ i 1))) ((= i n ))
        (do ((j 1 (+ j 1))) ((= j m ))
            (cond 
                  ( (zerop (aref array i j))
                    (setq temp (aref array i (- j 1)))
                    (setf (aref array i(- j 1)) 0) 
                    (setf (aref array i j  ) temp)
                    (setq i (- n 1))
                    (setq j (- m 1)) 
                    (print-array array)
                  )
              (t nil)
        )
     )
   )   
))


; the function next-states generates all the legal next-states
; for a given state.


(defun next-states (state array)
          (list-to-array state array)
          (move-down array)
          (list-to-array state array)
          (move-up array)
          (list-to-array state array)
          (move-left array)
          (list-to-array state array)
          (move-right array)
)






