(in-package :user)

;; Called inside category-rules.lisp in the Interpreter.
;; Produces *K concept from prep root.

(defun int-get-prep-K-concept (prep)
  (cond ((not (stringp prep))
	 (error "PREP not a string: ~s" prep))
	(t 
	 (or (gethash prep *prep-concept-table*)
	     (setf (gethash prep *prep-concept-table*)
		   (read-from-string (format nil "*K-~a" 
					     (replace-string "-" " " prep)
)))))))

;; Store results of building *K concepts, so we do it
;; once per prep.

(defvar *prep-concept-table*)

(setq *prep-concept-table*
      (make-hash-table :size 100 :test #'equal))

;; Defeat this function, since it tries to call (nonexistant) DoMo

(defun map-pp (head ir) 
  (declare (ignore head))
  ir)

;; 24-Feb-97 by EHN

(defun merge-q-modifier-slots (ir)
  (let ((q-mods (assoc 'q-modifier (rest ir)))
	(q2-mods (assoc 'q-modifier-2 (rest ir))))
    (cond ((and q-mods q2-mods)
	   (setf (second q-mods)
		 (combine-trees (second q-mods) (second q2-mods) :multiple))
	   (setf ir (remove q2-mods ir)))
	  (q2-mods
	   (setf (first q2-mods) 'q-modifier)))
    ir))

;; 24-Feb-97 by EHN

;; (setq *coda-delete-slots* nil) ; was (gap-role)

;; 24-Feb-97 by EHN

#|
(defun gap-argument-role (ir)
  (let ((gapped-role (second (assoc 'gap-role (rest ir))))
	ir-to-gap)
    (when gapped-role
	  (setf (second (assoc gapped-role (rest ir)))
		(copy-tree (second (assoc gapped-role (rest ir)))))
	  (setq ir-to-gap
		(second (assoc gapped-role (rest ir))))
	  (warn "ABOUT TO TWEAK! ~s" ir-to-gap)
	  (push (list 'gapped '+) 
		(rest ir-to-gap)))
    ir))
|#

