;      -*- Syntax: Common-Lisp; Package: USER; Base: 10; Mode: LISP -*-
;==============================================================================
;     File:  definitions.lisp
;	By:  Nicholas Brownlow	<ndb@clarit.com>
;     Path:  ../cmt/catalyst/amt-ana/english/interpreter-rules/<release-vs>
;  Started:  14 November 1994
; Modified:  03 December 1996	by <garof>
;
; Comments:  ndb: Miscellaneous definitions, including slots and features to
;	     skip. 
;
; Modified:  25 April 1995
;	By:  Nicholas Brownlow	<ndb@clarit.com>
;  Reasons:  Nicholas was the official "Interpreter" maintainer then.
;
; Modified:  26 April 1996
;	By:  Joseph Giampapa	<garof@cs.cmu.edu>
;  Reasons:  cf. PR cat/3642 Prepositional phrases conjoined under the IR slot
;	     ":MULTIPLE" are getting their orders reversed.  This modification
;	     sets the parameter so that their order is preserved.
;
; Modified:  18 November 1996
;	By:  Joseph Giampapa	<garof@cs>
;  Reasons:  Introduced version control.
;
; Modified:  03 December 1996
;	By:  Joseph Giampapa	<garof@cs.cmu.edu>
;  Reasons:  Removed references to "ir_vers_ctrl.lisp".
;
; Modified:  <date>
;	By:  <name>		<e-mail>
;  Reasons:  
;
;==============================================================================



;..............................................................................
;			Center for Machine Translation
;			  Carnegie Mellon University
;
;			Copyright (c) 1994, 1995, 1996
;	       Carnegie Mellon University.  All Rights Reserved.
;..............................................................................


;..............................................................................
;			      Package Statements
;..............................................................................
(in-package :user)


;..............................................................................
;			  Attempts at Version Control
;..............................................................................

;------------------------------------------------------------------------------
; For use by the maintainer's personal program.
;------------------------------------------------------------------------------
(defconstant *DEFINITIONS-VS* '5.0Analyzer)



;..............................................................................
;			     Parameter Definitions
;..............................................................................
(defparameter *Gapped-Argument-Head* '*G-GAPPED-ARGUMENT)
(defparameter *Gapped-Argument-IR* `(,*Gapped-Argument-Head* (GAPPED +)))


;------------------------------------------------------------------------------
(defparameter *You-IR*
  '(*G-PRONOUN
    (PERSON SECOND)
    (NUMBER (:OR SINGULAR PLURAL))))


;------------------------------------------------------------------------------
; 26-Apr-96-garof
; This function modifies global variable "*DONT-REVERSE-MULTIPLE-SLOTS*".  I
; have not yet found the function which actually accesses the value of that
; variable, though.
; See "../code/interpreter/<release>/interpreter.lisp" for more details on both
; the variable and its "add" function.
;------------------------------------------------------------------------------

(Add-Dont-Reverse-Multiple-Slotnames 'Q-Modifier 'Attribute)


;------------------------------------------------------------------------------
(features-to-skip
 attrib-adj				; 31-Oct-94 by ndb
 also-paren-entry
 allow-unlicensed-pp
 both-sg-and-pl
 cat
 clausal-coor-conj			; 21-Mar-95 by ndb
 colon
 comp
 compound-attrib-adj			; 31-Oct-94 by ndb
 coor-conj				; 10-Mar-95 by ndb
 count-noun-no-det			; 24-Apr-95 by ndb
 count-plus-minus			; 21-Apr-95 by ndb
 cte
 derived-trans
 disambig
 disambig-root				;  6-Apr-95 by ndb
 dmk-proper-noun
 expl-subj				; ????
 gap
 genpl
 gensg
 gerundive				; 13-Apr-95 by ndb
 head-fs-cat
 in-order-to				; 10-Jan-95 by ndb
 initial-adv				; 31-Oct-94 by ndb
 inner-passive				; 13-Apr-95 by ndb
 measurement-exp
 no-coord				; 29-Sep-94 by ndb
 non-object-pron
 non-restricted-pron
 not-word-final-s
 number-np				; 31-Oct-94 by ndb
 order					; 12-Jan-95 by ndb
 ortho
 paren-attachment-allowed
 parsed-number
 passive
 pastpart-as-adj
 percent				; 31-Oct-94 by ndb
 phrase
 phrasal-score
 post-purpose-check
 prefer-phrase
 restrictive				; 12-Jan-95 by ndb
 root
 sem
 single-letter
 standalone-tag
 standalone-callout
 token
 valency
 verb-mapping-trapped
 word-final-s				; 31-Oct-94 by ndb
 word-inflected)


;------------------------------------------------------------------------------
(defparameter *coda-delete-slots* '(gap-role)
  "Slots to delete after entire mapping process")



;---eof definitions.lisp---

