;      -*- Syntax: Common-Lisp; Package: USER; Base: 10; Mode: LISP -*-
;==============================================================================
;     File:  category-hierarchy.lisp
;	By:  Nicholas Brownlow	<ndb@clarit.com>
;     Path:  ../cmt/catalyst/amt-ana/english/interpreter-rules/<release-vs>
;  Started:  14 November 1994
; Modified:  03 December 1996	by <garof>
;
; Comments:  Interpreter Mapping Category Hierarchy
;
; Modified:  20 April 1995
;	By:  Nicholas Brownlow	<ndb@clarit.com>
;  Reasons:  Nicholas was the official "Interpreter" maintainer until then.
;
; Modified:  18 November 1996
;	By:  Joseph Giampapa	<garof@cs.cmu.edu>
;  Reasons:  To garof-ify this file, and to add version control markers to it.
;
; Modified:  03 December 1996
;	By:  Joseph Giampapa	<garof@cs.cmu.edu>
;  Reasons:  Removed references to "ir_vers_ctrl.lisp".
;
; Modified:  <date>
;	By:  <name>		<full e-mail>
;  Reasons:  
;
;==============================================================================


;..............................................................................
;			Center for Machine Translation
;			  Carnegie Mellon University
;
;			Copyright (c) 1994, 1995, 1996
;	       Carnegie Mellon University.  All Rights Reserved.
;..............................................................................


;..............................................................................
;			      Package Statements
;..............................................................................
(in-package :user)


;..............................................................................
;			  Attempts at Version Control
;..............................................................................

;------------------------------------------------------------------------------
; 18-Nov-96-garof:  For use by the maintainer's personal program.
;------------------------------------------------------------------------------
(defconstant *CATEGORY-HIERARCHY-VS* '5.0Analyzer)



;..............................................................................
;		    Interpreter Mapping Category Hierarchy
;..............................................................................


;------------------------------------------------------------------------------
; 18-Nov-96-garof:
; Defined in:  "../code/interpreter/<vs>Analyzer/irules.lisp"
;------------------------------------------------------------------------------
(clear-imcats)
(defimcat-root root)
(defimcat-default super)


;------------------------------------------------------------------------------
;			    Upper-level categories
;
; 18-Nov-96-garof:
; These categories define the order in which Interpreter rules will be applied
; to input F-Structures.  The classifying concept of an FS is the category,
; such as "(cat v)" for a section of FS which identifies a verb.  The arguments
; to the FS attribute "cat" are what are listed as arguments to "IMCAT"
; attribute ":cat".
;------------------------------------------------------------------------------
(defimcat
  :parent root
  :cat (super))

(defimcat
  :parent super
  :cat (super-modifier
	super-nominal
	super-number
	super-set
	super-special

	int p pron sym
	
	comparative
	mod
	subclause))

(defimcat
  :parent super-modifier
  :cat (adj adv quant))

(defimcat
  :parent super-nominal
  :cat (n v))

(defimcat
  :parent super-set
  :cat (set-subclause
	tag-coord
	tag-repeat))

(defimcat
  :parent super-special
  :cat (comp conj prep det sp))

(defimcat
  :parent n
  :cat (prop unit))


;------------------------------------------------------------------------------
;				    Numbers
;------------------------------------------------------------------------------
(defimcat
  :parent super-number
  :cat (super-number-simple
	super-number-wrapped))

(defimcat
  :parent super-number-simple
  :cat (card number ord))

(defimcat
  :parent super-number-wrapped
  :cat (fraction
	number-range
	number-tolerance
	ratio				; Added Tue Nov  1 1994 by ndb
	))


;------------------------------------------------------------------------------
;				     SGML
;------------------------------------------------------------------------------
(defimcat
  :parent n
  :cat super-sgml)

(defimcat
  :parent super-sgml
  :cat (tag-singleton
	tag-element
	tag-sequence)) 



;---eof category-hierarchy.lisp---
