;      -*- Syntax: Common-Lisp; Package: USER; Base: 10; Mode: LISP -*-
;==============================================================================
;     File:  argclass-hierarchy.lisp
;	By:  Nicholas Brownlow	<ndb@clarit.com>
;     Path:  ../cmt/catalyst/amt-ana/english/interpreter-rules/<release-vs>
;  Started:  01 November 1994
; Modified:  03 December 1996	by <garof>
;
; Comments:  Defines the verb argument mapping class hierarchy for the
;	     interpreter.
;
; Modified:  12 April 1995
;	By:  Nicholas Brownlow	<ndb@clarit.com>
;  Reasons:  Nicholas was the official "Interpreter" maintainer until then.
;
; Modified:  18 November 1996
;	By:  Joseph Giampapa	<garof@cs.cmu.edu>
;  Reasons:  To garof-ify this file, and to add version control markers to it.
;
; Modified:  03 December 1996
;	By:  Joseph Giampapa	<garof@cs.cmu.edu>
;  Reasons:  Removed references to "ir_vers_ctrl.lisp".
;
; Modified:  3-Feb-97 by EHN
;	By:  Eric Nyberg <ehn@cs.cmu.edu>
;  Reasons:  Changed references to args SUBJ, OBJ to SUBJECT, OBJECT.
;
; Modified:  <date>
;	By:  <name>		<full e-mail>
;  Reasons:  
;
;==============================================================================


;..............................................................................
;			Center for Machine Translation
;			  Carnegie Mellon University
;
;			   Copyright (c) 1994 - 1996
;	       Carnegie Mellon University.  All Rights Reserved.
;..............................................................................


;..............................................................................
;			      Package Statements
;..............................................................................
(in-package :user)


;..............................................................................
;			  Attempts at Version Control
;..............................................................................

;------------------------------------------------------------------------------
; For use by the maintainer's personal program.
;------------------------------------------------------------------------------
(defconstant *ARGCLASS-HIERARCHY-VS* '5.0Analyzer)


;..............................................................................
;			   The Hierarchy Starts Here
;..............................................................................
(clear-argclasses)


;------------------------------------------------------------------------------
; Hierarchical classes: define slot-slot mappings
;------------------------------------------------------------------------------

;; 19-Feb-97 by EHN -- Used for UPMC/CNBC (see comments at bottom of file)

(defargclass :HIERCLASS SUBJ-AGENT		:MAP ((SUBJECT . AGENT)))
(defargclass :HIERCLASS COMPL-COMPLEMENT	:MAP ((COMPL . COMPLEMENT)))
(defargclass :HIERCLASS OBJ-PATIENT		:MAP ((OBJECT . PATIENT)))
(defargclass :HIERCLASS OBJ-THEME		:MAP ((OBJECT . THEME)))
(defargclass :HIERCLASS SUBJ-EXPERIENCER	:MAP ((SUBJECT . EXPERIENCER)))
(defargclass :HIERCLASS OBJ-OBJECT		:MAP ((OBJECT . OBJECT)))
(defargclass :HIERCLASS SUBJ-THEME		:MAP ((SUBJECT . THEME)))
(defargclass :HIERCLASS OBJ-GOAL		:MAP ((OBJECT . GOAL)))
(defargclass :HIERCLASS OBJ-PREDICATE		:MAP ((OBJECT . PREDICATE)))
(defargclass :HIERCLASS PREDICATE-PREDICATE	:MAP ((PREDICATE . PREDICATE)))

;; 20-Feb-97 by EHN

(defargclass :HIERCLASS OBJ-RECIPIENT		:MAP ((OBJECT . RECIPIENT)))
(defargclass :HIERCLASS OBJECT2-GOAL		:MAP ((OBJECT2 . GOAL)))

;; ------------------------------------------------------------
 
(defargclass :HIERCLASS APCOMP-ATTRIBUTE	:MAP ((APCOMP . ATTRIBUTE)))
(defargclass :HIERCLASS SUBJ-BENEFICIARY	:MAP ((SUBJECT . BENEFICIARY)))
(defargclass :HIERCLASS SUBJ-POSSESSOR		:MAP ((SUBJECT . POSSESSOR)))
(defargclass :HIERCLASS SUBJ-STIMULUS		:MAP ((SUBJECT . STIMULUS)))
(defargclass :HIERCLASS OBJ-BENEFICIARY		:MAP ((OBJECT . BENEFICIARY)))
(defargclass :HIERCLASS OBJ-COMPARISON-THEME   :MAP ((OBJECT . COMPARISON-THEME)))
(defargclass :HIERCLASS OBJ-LOCATIVE		:MAP ((OBJECT . LOCATIVE)))
(defargclass :HIERCLASS OBJ-PATH		:MAP ((OBJECT . PATH)))
(defargclass :HIERCLASS OBJ-SOURCE		:MAP ((OBJECT . SOURCE)))
(defargclass :HIERCLASS OBJ-STIMULUS		:MAP ((OBJECT . STIMULUS)))
(defargclass :HIERCLASS OBJ2-COMPARISON-THEME :MAP ((OBJ2 . COMPARISON-THEME)))
(defargclass :HIERCLASS OBJ2-OBJECT		:MAP ((OBJ2 . OBJECT)))
(defargclass :HIERCLASS OBJ2-THEME		:MAP ((OBJ2 . THEME)))
(defargclass :HIERCLASS XCOMP-COMPLEMENT	:MAP ((XCOMP . COMPLEMENT)))
(defargclass :HIERCLASS SCOMP-COMPLEMENT	:MAP ((SCOMP . COMPLEMENT)))

(defargclass :HIERCLASS PASSIVE-ALTERNATION
  :FEATURES ((PASSIVE-ALTERNATION . +)))


;------------------------------------------------------------------------------
; Verb base classes
;------------------------------------------------------------------------------

;; 19-Feb-97 by EHN - Used for UPMC/CNBC (see comments at bottom of file)

(defargclass :CLASS AGENT
  :INHERIT (SUBJ-AGENT))

(defargclass :CLASS AGENT+COMPLEMENT
  :INHERIT (SUBJ-AGENT COMPL-COMPLEMENT))

(defargclass :CLASS AGENT+PATIENT
  :INHERIT (SUBJ-AGENT OBJ-PATIENT PASSIVE-ALTERNATION))

(defargclass :CLASS AGENT+THEME
  :INHERIT (SUBJ-AGENT OBJ-THEME PASSIVE-ALTERNATION))

(defargclass :CLASS EXPERIENCER+THEME
  :INHERIT (SUBJ-EXPERIENCER OBJ-THEME PASSIVE-ALTERNATION))

(defargclass :CLASS POSSESSOR+OBJECT
  :INHERIT (SUBJ-POSSESSOR OBJ-OBJECT PASSIVE-ALTERNATION))

(defargclass :CLASS THEME
  :INHERIT (SUBJ-THEME))

(defargclass :CLASS THEME+COMPLEMENT
  :INHERIT (SUBJ-THEME COMPL-COMPLEMENT))

(defargclass :CLASS THEME+GOAL
  :INHERIT (SUBJ-THEME OBJ-GOAL PASSIVE-ALTERNATION))

;; 19-Feb-97 by EHN - added some more (CNBC)

(defargclass :CLASS BENEFICIARY+THEME
  :INHERIT (SUBJ-BENEFICIARY OBJ-THEME PASSIVE-ALTERNATION))

(defargclass :CLASS BENEFICIARY+GOAL
  :INHERIT (SUBJ-BENEFICIARY OBJ-GOAL PASSIVE-ALTERNATION))

(defargclass :CLASS THEME+PREDICATE
  :INHERIT (SUBJ-THEME OBJ-PREDICATE PREDICATE-PREDICATE PASSIVE-ALTERNATION))

;; 20-Feb-97 by EHN

(defargclass :CLASS AGENT+PREDICATE
  :INHERIT (SUBJ-AGENT OBJ-PREDICATE PREDICATE-PREDICATE PASSIVE-ALTERNATION))

(defargclass :CLASS AGENT+RECIPIENT+PREDICATE
  :INHERIT (SUBJ-AGENT OBJ-RECIPIENT PREDICATE-PREDICATE PASSIVE-ALTERNATION))

(defargclass :CLASS AGENT+THEME+GOAL
  :INHERIT (SUBJ-AGENT OBJ-THEME OBJECT2-GOAL PASSIVE-ALTERNATION))

;; 23-Feb-97 by EHN

(defargclass :CLASS AGENT+THEME+PREDICATE
  :inherit (SUBJ-AGENT OBJ-THEME PREDICATE-PREDICATE PASSIVE-ALTERNATION))

;; ------------------------------------------------------------

(defargclass :CLASS AGENT+BENEFICIARY
  :INHERIT (SUBJ-AGENT OBJ-BENEFICIARY))

(defargclass :CLASS AGENT+BENEFICIARY+COMPLEMENT
  :INHERIT (SUBJ-AGENT OBJ-BENEFICIARY XCOMP-COMPLEMENT))

(defargclass :CLASS AGENT+GOAL
  :INHERIT (SUBJ-AGENT OBJ-GOAL PASSIVE-ALTERNATION))

(defargclass :CLASS AGENT+GOAL+COMPLEMENT
  :INHERIT
  (SUBJ-AGENT OBJ-GOAL XCOMP-COMPLEMENT SCOMP-COMPLEMENT PASSIVE-ALTERNATION))

(defargclass :CLASS AGENT+GOAL+THEME
  :INHERIT (SUBJ-AGENT OBJ-GOAL OBJ2-THEME))

(defargclass :CLASS AGENT+PATIENT+ATTRIBUTE
  :INHERIT (SUBJ-AGENT OBJ-PATIENT APCOMP-ATTRIBUTE PASSIVE-ALTERNATION))

(defargclass :CLASS AGENT+PATIENT+ATTRIBUTE
  :INHERIT (SUBJ-AGENT OBJ-PATIENT APCOMP-ATTRIBUTE PASSIVE-ALTERNATION))

(defargclass :CLASS AGENT+PATIENT+COMPLEMENT
  :INHERIT (SUBJ-AGENT OBJ-PATIENT XCOMP-COMPLEMENT PASSIVE-ALTERNATION))

(defargclass :CLASS AGENT+SOURCE
  :INHERIT (SUBJ-AGENT OBJ-SOURCE PASSIVE-ALTERNATION))

(defargclass :CLASS AGENT+SOURCE+COMPLEMENT
  :INHERIT (SUBJ-AGENT OBJ-SOURCE XCOMP-COMPLEMENT))

(defargclass :CLASS AGENT+GOAL+COMPLEMENT
  :INHERIT (SUBJ-AGENT OBJ-GOAL XCOMP-COMPLEMENT PASSIVE-ALTERNATION))

(defargclass :CLASS AGENT+THEME+ATTRIBUTE
  :INHERIT (SUBJ-AGENT OBJ-THEME APCOMP-ATTRIBUTE))

(defargclass :CLASS AGENT+THEME+COMPLEMENT
  :INHERIT (SUBJ-AGENT OBJ-THEME XCOMP-COMPLEMENT PASSIVE-ALTERNATION))

(defargclass :CLASS AGENT+THEME+OBJECT
  :INHERIT (SUBJ-AGENT OBJ-THEME OBJ2-OBJECT))

(defargclass :CLASS BENEFICIARY
  :INHERIT (SUBJ-BENEFICIARY))

(defargclass :CLASS EXPERIENCER
  :INHERIT (SUBJ-EXPERIENCER))

(defargclass :CLASS EXPERIENCER+STIMULUS
  :INHERIT (SUBJ-EXPERIENCER OBJ-STIMULUS PASSIVE-ALTERNATION))

(defargclass :CLASS STIMULUS
  :INHERIT (SUBJ-STIMULUS PASSIVE-ALTERNATION))

(defargclass :CLASS THEME+ATTRIBUTE
  :INHERIT (SUBJ-THEME APCOMP-ATTRIBUTE))

(defargclass :CLASS THEME+BENEFICIARY
  :INHERIT (SUBJ-THEME OBJ-BENEFICIARY))

(defargclass :CLASS THEME+COMPARISON-THEME
  :INHERIT (SUBJ-THEME OBJ-COMPARISON-THEME PASSIVE-ALTERNATION))

(defargclass :CLASS THEME+COMPARISON-THEME+COMPLEMENT
  :INHERIT
  (SUBJ-THEME OBJ-COMPARISON-THEME XCOMP-COMPLEMENT PASSIVE-ALTERNATION))

(defargclass :CLASS THEME+LOCATIVE
  :INHERIT (SUBJ-THEME OBJ-LOCATIVE PASSIVE-ALTERNATION))

(defargclass :CLASS THEME+OBJECT
  :INHERIT (SUBJ-THEME OBJ-OBJECT PASSIVE-ALTERNATION))

(defargclass :CLASS THEME+OBJECT+COMPLEMENT
  :INHERIT (SUBJ-THEME OBJ-OBJECT XCOMP-COMPLEMENT PASSIVE-ALTERNATION))

(defargclass :CLASS THEME+PATH
  :INHERIT (SUBJ-THEME OBJ-PATH PASSIVE-ALTERNATION))

(defargclass :CLASS THEME+SOURCE
  :INHERIT (SUBJ-THEME OBJ-SOURCE PASSIVE-ALTERNATION))


;------------------------------------------------------------------------------
; Multiple classes: constraints restrict inheritance
;------------------------------------------------------------------------------
(defargclass :MULTICLASS AGENT+COMPLEMENT/AGENT+BENEFICIARY+COMPLEMENT
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT+COMPLEMENT)
	    (:TEST ((VALENCY TRANS)) AGENT+BENEFICIARY+COMPLEMENT)))

(defargclass :MULTICLASS AGENT+COMPLEMENT/AGENT+GOAL+COMPLEMENT
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT+COMPLEMENT)
	    (:TEST ((VALENCY TRANS)) AGENT+GOAL+COMPLEMENT)))

(defargclass :MULTICLASS AGENT+COMPLEMENT/AGENT+PATIENT
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT+COMPLEMENT)
	    (:TEST ((VALENCY TRANS)) AGENT+PATIENT)))

(defargclass :MULTICLASS AGENT+COMPLEMENT/AGENT+PATIENT+COMPLEMENT
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT+COMPLEMENT)
	    (:TEST ((VALENCY TRANS)) AGENT+PATIENT+COMPLEMENT)))

(defargclass :MULTICLASS AGENT+COMPLEMENT/AGENT+SOURCE+COMPLEMENT
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT+COMPLEMENT)
	    (:TEST ((VALENCY TRANS)) AGENT+SOURCE+COMPLEMENT)))

(defargclass :MULTICLASS AGENT+COMPLEMENT/AGENT+THEME
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT+COMPLEMENT)
	    (:TEST ((VALENCY TRANS)) AGENT+THEME)))

;; 19-Feb-97 by EHN - for UPMC/CNBC

(defargclass :MULTICLASS AGENT+COMPLEMENT/THEME+COMPLEMENT/AGENT+THEME
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT+COMPLEMENT)
	    (:TEST ((VALENCY TRANS)) AGENT+THEME)))

;; 20-Feb-97 by EHN

(defargclass :MULTICLASS THEME/AGENT+THEME/AGENT+PREDICATE
  :INHERIT ((:TEST ((OBJECT :DEFINED)) AGENT+THEME)
	    (:TEST ((PREDICATE :DEFINED)) AGENT+PREDICATE)
	    (:TEST ((SUBJECT :DEFINED)) THEME)))

;; 23-Feb-97 by EHN

(defargclass :MULTICLASS AGENT+PREDICATE/AGENT+THEME+PREDICATE
  :INHERIT ((:TEST ((OBJECT :UNDEFINED)) AGENT+PREDICATE)
	    (:TEST ((OBJECT :DEFINED)) AGENT+THEME+PREDICATE)
))

(defargclass :CLASS THEME+SOURCE+COMPARISON-THEME+COMPLEMENT
  :INHERIT
  (SUBJ-THEME OBJ-SOURCE OBJ2-COMPARISON-THEME XCOMP-COMPLEMENT
	      PASSIVE-ALTERNATION))(defargclass :CLASS THEME+SOURCE+COMPARISON-THEME+COMPLEMENT
  :INHERIT
  (SUBJ-THEME OBJ-SOURCE OBJ2-COMPARISON-THEME XCOMP-COMPLEMENT
	      PASSIVE-ALTERNATION))


;;------------------------------------------------------------

;; this one dies for *A-CONTINUE in UPMC

(defargclass :MULTICLASS AGENT+THEME/THEME+COMPLEMENT
  :INHERIT ((:TEST ((OBJECT :UNDEFINED)) THEME+COMPLEMENT)
	    (:TEST ((OBJECT :DEFINED)) AGENT+THEME)))

(defargclass :MULTICLASS AGENT+THEME/AGENT+COMPLEMENT
  :INHERIT ((:TEST ((OBJECT :UNDEFINED)) AGENT+COMPLEMENT)
	    (:TEST ((OBJECT :DEFINED)) AGENT+THEME)))

(defargclass :MULTICLASS AGENT+COMPLEMENT/AGENT+THEME+COMPLEMENT
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT+COMPLEMENT)
	    (:TEST ((VALENCY TRANS)) AGENT+THEME+COMPLEMENT)))

(defargclass :MULTICLASS AGENT+PATIENT/AGENT+GOAL+THEME
  :INHERIT ((:TEST ((VALENCY TRANS)) AGENT+PATIENT)
	    (:TEST ((VALENCY DITRANS)) AGENT+GOAL+THEME)))

(defargclass :MULTICLASS AGENT+THEME/AGENT+GOAL+THEME
  :INHERIT ((:TEST ((VALENCY TRANS)) AGENT+THEME)
	    (:TEST ((VALENCY DITRANS)) AGENT+GOAL+THEME)))

(defargclass :MULTICLASS AGENT/AGENT+BENEFICIARY
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT)
	    (:TEST ((VALENCY TRANS)) AGENT+BENEFICIARY)))

(defargclass :MULTICLASS AGENT/AGENT+BENEFICIARY+COMPLEMENT
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT)
	    (:TEST ((VALENCY TRANS)) AGENT+BENEFICIARY+COMPLEMENT)))

(defargclass :MULTICLASS AGENT/AGENT+GOAL
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT)
	    (:TEST ((VALENCY TRANS)) AGENT+GOAL)))

(defargclass :MULTICLASS AGENT/AGENT+PATIENT
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT)
	    (:TEST ((VALENCY TRANS)) AGENT+PATIENT)))

(defargclass :MULTICLASS AGENT/AGENT+SOURCE
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT)
	    (:TEST ((VALENCY TRANS)) AGENT+SOURCE)))

(defargclass :MULTICLASS AGENT/AGENT+THEME
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT)
	    (:TEST ((VALENCY TRANS)) AGENT+THEME)))

(defargclass :MULTICLASS AGENT/AGENT+THEME+ATTRIBUTE
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT)
	    (:TEST ((VALENCY TRANS)) AGENT+THEME+ATTRIBUTE)))

(defargclass :MULTICLASS BENEFICIARY/THEME+BENEFICIARY
  :INHERIT ((:TEST ((VALENCY INTRANS)) BENEFICIARY)
	    (:TEST ((VALENCY TRANS)) THEME+BENEFICIARY)))

(defargclass :MULTICLASS EXPERIENCER/EXPERIENCER+THEME
  :INHERIT ((:TEST ((VALENCY INTRANS)) EXPERIENCER)
	    (:TEST ((VALENCY TRANS)) EXPERIENCER+THEME)))

(defargclass :MULTICLASS THEME+ATTRIBUTE/AGENT+THEME+ATTRIBUTE
  :INHERIT ((:TEST ((VALENCY INTRANS)) THEME+ATTRIBUTE)
	    (:TEST ((VALENCY TRANS)) AGENT+THEME+ATTRIBUTE)))

(defargclass :MULTICLASS THEME+ATTRIBUTE/THEME+GOAL
  :INHERIT ((:TEST ((VALENCY INTRANS)) THEME+ATTRIBUTE)
	    (:TEST ((VALENCY TRANS)) THEME+GOAL)))

(defargclass :MULTICLASS THEME+COMPLEMENT/AGENT+THEME
  :INHERIT ((:TEST ((VALENCY INTRANS)) THEME+COMPLEMENT)
	    (:TEST ((VALENCY TRANS)) AGENT+THEME)))

(defargclass :MULTICLASS THEME+COMPLEMENT/AGENT+THEME+COMPLEMENT
  :INHERIT ((:TEST ((VALENCY INTRANS)) THEME+COMPLEMENT)
	    (:TEST ((VALENCY TRANS)) AGENT+THEME+COMPLEMENT)))

(defargclass :MULTICLASS THEME+COMPLEMENT/EXPERIENCER+THEME
  :INHERIT ((:TEST ((VALENCY INTRANS)) THEME+COMPLEMENT)
	    (:TEST ((VALENCY TRANS)) EXPERIENCER+THEME)))

(defargclass :MULTICLASS THEME+COMPLEMENT/THEME+COMPARISON-THEME+COMPLEMENT/THEME+SOURCE+COMPARISON-THEME+COMPLEMENT
  :INHERIT ((:TEST ((VALENCY INTRANS)) THEME+COMPLEMENT)
	    (:TEST ((VALENCY TRANS)) THEME+COMPARISON-THEME+COMPLEMENT)
	    (:TEST ((VALENCY DITRANS))
		   THEME+SOURCE+COMPARISON-THEME+COMPLEMENT)))

(defargclass :MULTICLASS THEME+COMPLEMENT/THEME+OBJECT
  :INHERIT ((:TEST ((VALENCY INTRANS)) THEME+COMPLEMENT)
	    (:TEST ((VALENCY TRANS)) THEME+OBJECT)))

(defargclass :MULTICLASS THEME/AGENT+PATIENT
  :INHERIT ((:TEST ((VALENCY INTRANS)) THEME)
	    (:TEST ((VALENCY TRANS)) AGENT+PATIENT)))

;; 23-Feb-97 by EHN - experimental workaround for the fact
;; that CNBC doesn't have VALENCY in the f-s in a state we
;; can use.

(defargclass :MULTICLASS THEME/AGENT+THEME
  :INHERIT ((:TEST ((OBJECT :UNDEFINED)) THEME)
	    (:TEST ((OBJECT :DEFINED)) AGENT+THEME)))

(defargclass :MULTICLASS THEME/AGENT+THEME/AGENT+THEME+OBJECT
  :INHERIT ((:TEST ((VALENCY INTRANS)) THEME)
	    (:TEST ((VALENCY TRANS)) AGENT+THEME)
	    (:TEST ((VALENCY DITRANS)) AGENT+THEME+OBJECT)))

(defargclass :MULTICLASS THEME/THEME+GOAL
  :INHERIT ((:TEST ((VALENCY INTRANS)) THEME)
	    (:TEST ((VALENCY TRANS)) THEME+GOAL)))

(defargclass :MULTICLASS THEME/THEME+PATH
  :INHERIT ((:TEST ((VALENCY INTRANS)) THEME)
	    (:TEST ((VALENCY TRANS)) THEME+PATH)))

(defargclass :MULTICLASS THEME/THEME+SOURCE
  :INHERIT ((:TEST ((VALENCY INTRANS)) THEME)
	    (:TEST ((VALENCY TRANS)) THEME+SOURCE)))

(defargclass
  :MULTICLASS THEME+ATTRIBUTE/AGENT+THEME+ATTRIBUTE!AGENT+THEME+COMPLEMENT
  :INHERIT ((:TEST ((VALENCY INTRANS)) THEME+ATTRIBUTE)
	    (:TEST ((VALENCY TRANS) (APCOMP :DEFINED)) AGENT+THEME+ATTRIBUTE)
	    (:TEST (*OR* ((VALENCY TRANS) (XCOMP :DEFINED))
			 ((VALENCY TRANS) (SCOMP :DEFINED)))
		   AGENT+THEME+COMPLEMENT)))

(defargclass :MULTICLASS THEME+ATTRIBUTE!THEME+COMPLEMENT
  :INHERIT ((:TEST ((APCOMP :DEFINED)) THEME+ATTRIBUTE)
	    (:TEST (*OR* ((XCOMP :DEFINED)) ((SCOMP :DEFINED)))
		   THEME+COMPLEMENT)))

(defargclass :MULTICLASS AGENT+PATIENT+ATTRIBUTE!AGENT+PATIENT+COMPLEMENT
  :INHERIT ((:TEST ((APCOMP :DEFINED)) AGENT+PATIENT+ATTRIBUTE)
	    (:TEST ((XCOMP :DEFINED)) AGENT+PATIENT+COMPLEMENT)))

(defargclass
  :MULTICLASS
  AGENT+COMPLEMENT/AGENT+THEME!AGENT+GOAL+COMPLEMENT/AGENT+GOAL+THEME
  :INHERIT ((:TEST ((VALENCY INTRANS)) AGENT+COMPLEMENT)
	    (:TEST (*OR* ((VALENCY TRANS) (XCOMP :DEFINED))
			 ((VALENCY TRANS) (SCOMP :DEFINED)))
		   AGENT+GOAL+COMPLEMENT)
	    (:TEST ((VALENCY TRANS)) AGENT+THEME)
	    (:TEST ((VALENCY DITRANS)) AGENT+GOAL+THEME)))

(defargclass
  :MULTICLASS
  THEME+ATTRIBUTE!THEME+COMPLEMENT/AGENT+THEME+ATTRIBUTE!AGENT+THEME+COMPLEMENT
  :INHERIT ((:TEST ((VALENCY TRANS) (APCOMP :DEFINED)) THEME+ATTRIBUTE)
	    (:TEST (*OR* ((VALENCY TRANS) (XCOMP :DEFINED))
			 ((VALENCY TRANS) (SCOMP :DEFINED)))
		   THEME+COMPLEMENT)
	    (:TEST ((VALENCY DITRANS) (APCOMP :DEFINED))
		   AGENT+THEME+ATTRIBUTE)
	    (:TEST (*OR* ((VALENCY DITRANS) (XCOMP :DEFINED))
			 ((VALENCY DITRANS) (SCOMP :DEFINED)))
		   AGENT+THEME+COMPLEMENT)))

;;----------------------------------------------------------------------
;;  5-Feb-97 by EHN -- missing entries:
;;
;; AGENT+GOAL+INSTRUMENT, ((ROOT "miss") (SEM *A-MISS))
;; AGENT+GOAL+INSTRUMENT, ((ROOT "miss") (SEM *A-MISS))
;; BENEFICIARY+THEME, ((ROOT "top") (SEM *A-TOP))
;; BENEFICIARY+GOAL, ((ROOT "become") (SEM *A-BECOME))
;; THEME+LOCATION/AGENT+THEME+LOCATION, ((ROOT "close") (SEM *A-CLOSE))
;; THEME+LOCATION/AGENT+THEME+LOCATION, ((ROOT "close") (SEM *A-CLOSE))
;; AGENT+THEME+SOURCE+INSTRUMENT, ((ROOT "buy") (SEM *A-BUY))
;; AGENT+THEME+SOURCE+INSTRUMENT, ((ROOT "buy") (SEM *A-BUY))
;; AGENT+THEME+SOURCE+INSTRUMENT, ((ROOT "buy") (SEM *A-BUY))
;; AGENT+THEME+SOURCE+INSTRUMENT, ((ROOT "buy") (SEM *A-BUY))
;; AGENT+THEME+SOURCE+INSTRUMENT, ((ROOT "buy") (SEM *A-BUY))
;; AGENT+THEME+SOURCE+INSTRUMENT, ((ROOT "buy") (SEM *A-BUY))
;; BENEFICIARY+THEME+GOAL, ((ROOT "see") (SEM *A-SEE-AS))
;; BENEFICIARY+THEME+GOAL, ((ROOT "see") (SEM *A-SEE-AS))
;; THEME+LOCATION/AGENT+THEME+LOCATION, ((ROOT "end") (SEM *A-END))
;; THEME+LOCATION/AGENT+THEME+LOCATION, ((ROOT "close") (SEM *A-CLOSE))
;; AGENT+THEME+BENEFICIARY/AGENT+THEME, ((ROOT "say") (SEM *A-SAY))
;; AGENT+THEME+BENEFICIARY/AGENT+THEME, ((ROOT "say") (SEM *A-SAY))
;; THEME+LOCATION/AGENT+THEME+LOCATION, ((ROOT "close") (SEM *A-CLOSE))
;; THEME+LOCATION/AGENT+THEME+LOCATION, ((ROOT "close") (SEM *A-CLOSE))
;; NIL, (NIL NIL)

;; 19-Feb-97 by EHN -- commented out.
#|
;; Some unique missing classes:
;;
;; AGENT+GOAL+INSTRUMENT -> AGENT+GOAL
(defargclass :CLASS AGENT+GOAL+INSTRUMENT
  :INHERIT (SUBJ-AGENT OBJ-GOAL PASSIVE-ALTERNATION))
;; AGENT+THEME+BENEFICIARY/AGENT+THEME -> AGENT+THEME
(defargclass :CLASS AGENT+THEME+BENEFICIARY/AGENT+THEME
  :INHERIT (SUBJ-AGENT OBJ-THEME PASSIVE-ALTERNATION))
;; AGENT+THEME+SOURCE+INSTRUMENT -> AGENT+THEME
(defargclass :CLASS AGENT+THEME+SOURCE+INSTRUMENT
  :INHERIT (SUBJ-AGENT OBJ-THEME PASSIVE-ALTERNATION))
;; BENEFICIARY+GOAL -> AGENT+THEME
(defargclass :CLASS BENEFICIARY+GOAL 
  :INHERIT (SUBJ-AGENT OBJ-THEME PASSIVE-ALTERNATION))
;; BENEFICIARY+THEME -> AGENT+THEME
(defargclass :CLASS BENEFICIARY+THEME
  :INHERIT (SUBJ-AGENT OBJ-THEME PASSIVE-ALTERNATION))
;; BENEFICIARY+THEME+GOAL -> AGENT+THEME
(defargclass :CLASS BENEFICIARY+THEME+GOAL
  :INHERIT (SUBJ-AGENT OBJ-THEME PASSIVE-ALTERNATION))
;; THEME+LOCATION/AGENT+THEME+LOCATION -> AGENT+THEME
(defargclass :CLASS THEME+LOCATION/AGENT+THEME+LOCATION
  :INHERIT (SUBJ-AGENT OBJ-THEME PASSIVE-ALTERNATION))
;; NIL --> IGNORE
|#

;; 19-Feb-97 by EHN - Latest consensus for UPMC/CNBC
#|
AGENT:                SUBJECT -> AGENT
AGENT+COMPLEMENT:     SUBJECT -> AGENT        COMPL ->  COMPLEMENT
AGENT+PATIENT:        SUBJECT -> AGENT        OBJECT -> PATIENT
AGENT+THEME:          SUBJECT -> AGENT        OBJECT -> THEME
EXPERIENCER+THEME:    SUBJECT -> EXPERIENCER  OBJECT -> THEME
POSSESSOR+OBJECT:     SUBJECT -> POSSESSOR    OBJECT -> OBJECT
THEME:                SUBJECT -> THEME  
THEME+COMPLEMENT:     SUBJECT -> THEME        COMPL ->  COMPLEMENT
THEME+GOAL:           SUBJECT -> THEME        OBJECT -> GOAL

AGENT+COMPLEMENT/THEME+COMPLEMENT/AGENT+THEME
|#

;; 19-Feb-97 by EHN -- for CNBC -- needs selection criteria

(defargclass :MULTICLASS AGENT+THEME/BENEFICIARY+THEME
  :INHERIT ((:TEST ((VALENCY TRANS)) AGENT+THEME)
	    (:TEST ((VALENCY TRANS)) BENEFICIARY+THEME)))

(defargclass :MULTICLASS THEME+PREDICATE/THEME+COMPLEMENT
  :INHERIT ((:TEST ((PREDICATE :DEFINED)) THEME+PREDICATE)
	    (:TEST ((COMPL :DEFINED)) THEME+COMPLEMENT)))

;---eof argclass-hierarchy.eof---
