;; 22-July-1996-eja: Here is your data. I am also creating a PR of the
;; corrections and questions I noted in this task. There are only two
;; comments outside of the parentheses, Context Independent, which means
;; the current development of the SMCS codes is not fine grained enough
;; to differentiate between these senses and also some notation of where
;; the senses are exclusive. We need to decide on the next step of how to
;; resolve more of these-- many can be done with a hierarchical model
;; that can make use of syntactic/semantic relations other than those
;; currently dealt with in the triples. Other differences could be
;; captured by adding information to the SMCS model, such as
;; doctype. (Or, by picking this information up from the header of the
;; IE.)
;; 	
;; Generated from /kaddath/usr2/catalyst/smcs/smcs-data-410.lisp and dmk41101

(assign-smcs "absorber" N
  (*O-ABSORBER-2 7320)
  (*O-ABSORBER-1))

;; Context Independent

(assign-smcs "accept" V
  (*A-ACCEPT-3)
  (*A-ACCEPT-2)
  (*A-ACCEPT-1))

;; Context Independent

(assign-smcs "actuator" N
  (*O-ACTUATOR-2)
  (*O-ACTUATOR-1))

;; Context Independent

(assign-smcs "adapter" N
  (*O-ADAPTER-2)
  (*O-ADAPTER-1 1400 1550 1900 1450 4450 5700 7300))

(assign-smcs "add" V
  (*A-ADD-2)
  (*A-ADD-1))

;; Context independent

(assign-smcs "agent" N
  (*O-AGENT-2)
  (*O-AGENT-1))

;; Context Independent

(assign-smcs "agree" V
  (*A-AGREE-2)
  (*A-AGREE-1))

;; Context Independent

(assign-smcs "analyzer" N
  (*O-ANALYZER-2)
  (*O-ANALYZER-1))

;; Context Independent

(assign-smcs "anchor" N
  (*O-ANCHOR-2)
  (*O-ANCHOR-1))

;; Context Independent

(assign-smcs "angle" N
  (*O-ANGLE-2)
  (*O-ANGLE-1))

;; Context Independent

(assign-smcs "appear" V
  (*A-APPEAR-3)
  (*A-APPEAR-2)
  (*A-APPEAR-1))

;; Context Independent

(assign-smcs "application" N
  (*O-APPLICATION-3)
  (*O-APPLICATION-2)
  (*O-APPLICATION-1))

;; Context Independent

(assign-smcs "apply" V
  (*A-APPLY-2)
  (*A-APPLY-1))

;; Context Independent

(assign-smcs "apron" N
  (*O-APRON-2)
  (*O-APRON-1 5300 6200))

(assign-smcs "arbor" N
  (*O-ARBOR-2)
  (*O-ARBOR-1))

;; Context Independent

(assign-smcs "arm" N
  (*O-ARM-2)
  (*O-ARM-1))

;; Context Independent

(assign-smcs "arrange" V
  (*A-ARRANGE-2)
  (*A-ARRANGE-1))

;; Context Independent

(assign-smcs "assembly" N
  (*O-ASSEMBLY-2)
  (*O-ASSEMBLY-1))

;; Context Independent

(assign-smcs "average" ADJ
  (*P-AVERAGE-2)
  (*P-AVERAGE-1))

;; Context Independent

(assign-smcs "back" N
  (*O-BACK-2)
  (*O-BACK-1))

;; Context Independent

(assign-smcs "backup" N
  (*O-BACKUP-2)
  (*O-BACKUP-1))

;; Context Independent

(assign-smcs "bag" N
  (*O-BAG-2)
  (*O-BAG-1 7200))

(assign-smcs "ball" N
  (*O-BALL-3)
  (*O-BALL-2)
  (*O-BALL-1))

;; Context Independent

(assign-smcs "ballast" N
  (*O-BALLAST-2 1400 1550 1900 1450 4450 5700 7300)
  (*O-BALLAST-1))

(assign-smcs "band" N
  (*O-BAND-2 7300)
  (*O-BAND-1))

(assign-smcs "bank" N
  (*O-BANK-2)
  (*O-BANK-1))

;; Context Independent

(assign-smcs "barrel" N
  (*O-BARREL-2)
  (*O-BARREL-1))

;; Context Independent

(assign-smcs "base" N
  (*O-BASE-2)
  (*O-BASE-1))

;; Context Independent

(assign-smcs "basis" N
  (*O-BASIS-2)
  (*O-BASIS-1))

;; Context Independent

(assign-smcs "beam" N
  (*O-BEAM-2)
  (*O-BEAM-1))

;; Context Independent

(assign-smcs "bearing" N
  (*O-BEARING-2)
  (*O-BEARING-1 1200))

;; Context Independent

(assign-smcs "bellcrank" N
  (*O-BELLCRANK-2)
  (*O-BELLCRANK-1))

;; Context Independent

(assign-smcs "belt" N
  (*O-BELT-3)
  (*O-BELT-2)
  (*O-BELT-1))

;; Context Independent

(assign-smcs "bench" N
  (*O-BENCH-2)
  (*O-BENCH-1))

;; Context Independent

(assign-smcs "bit" N
  (*O-BIT-3)
  (*O-BIT-2)
  (*O-BIT-1 1900 7300))

(assign-smcs "blade" N
  (*O-BLADE-4 :ALL)
  (*O-BLADE-3 :ALL)
  (*O-BLADE-2 1350 7300)
  (*O-BLADE-1 1050 3000 3100))

(assign-smcs "blanket" N
  (*O-BLANKET-2 1200)
  (*O-BLANKET-1))

(assign-smcs "block" N
  (*O-BLOCK-7 (:PLUS 3000) 4050 4100 (:PLUS 5000) (:PLUS 6000))
  (*O-BLOCK-6 :ALL)
  (*O-BLOCK-5 1400 1450 1500 1550 1600 1900 4450 4800 7250 7300 7400
   7450)
  (*O-BLOCK-4 :ALL)
  (*O-BLOCK-3 :ALL)
  (*O-BLOCK-2 1100 1150 1200 1251)
  (*O-BLOCK-1 :ALL))

(assign-smcs "blow off" V
  ;; Old/phrasal entry not in dmk41101 single-word lexicon
  (*A-BLOW-OFF-1)
  (*A-BLOW-OFF-2))

;; Context Independent

(assign-smcs "blow out" V
  ;; Old/phrasal entry not in dmk41101 single-word lexicon
  (*A-BLOW-OUT-1)
  (*A-BLOW-OUT-2))

;; Context Independent

(assign-smcs "blower" N
  (*O-BLOWER-2)
  (*O-BLOWER-1 1350 7300))

(assign-smcs "board" N
  (*O-BOARD-5 1600 7450)
  (*O-BOARD-4 1600 7450)
  (*O-BOARD-3 1400 1500 1900 4800 5700)
  (*O-BOARD-2 :ALL)
  (*O-BOARD-1 :ALL))

(assign-smcs "body" N
  (*O-BODY-2 7050)
  (*O-BODY-1 :ALL))

(assign-smcs "bonnet" N
  (*O-BONNET-2 1350)
  (*O-BONNET-1))

(assign-smcs "boost" N
  (*O-BOOST-2 1400 1450 1550 1900 5700 7300)
  (*O-BOOST-1))

(assign-smcs "booster" N
  (*O-BOOSTER-2)
  (*O-BOOSTER-1 1450))

(assign-smcs "bottle" N
  (*O-BOTTLE-2)
  (*O-BOTTLE-1))

;; Context Independent

(assign-smcs "bowl" N
  (*O-BOWL-2)
  (*O-BOWL-1 6200))

(assign-smcs "box" N
  (*O-BOX-2 1400 1450 1550 1900 4450 5700 7300)
  (*O-BOX-1))

;; Context Independent

(assign-smcs "brace" N
  (*O-BRACE-2)
  (*O-BRACE-1))

;; Context Independent

(assign-smcs "braid" N
  (*O-BRAID-3)
  (*O-BRAID-2)
  (*O-BRAID-1 1400))

(assign-smcs "branch" N
  (*O-BRANCH-2)
  (*O-BRANCH-1))

;; Context Independent

(assign-smcs "break" V
  (*A-BREAK-3 1400 1450 1550 1900 4450 4700 7300)
  (*A-BREAK-2)
  (*A-BREAK-1))

(assign-smcs "bridge" N
  (*O-BRIDGE-2)
  (*O-BRIDGE-1 1400 1450 1550 1900 4450 4700 7300))

(assign-smcs "bridge" V
  (*A-BRIDGE-3 1400 1450 1550 1900 4450 4700 7300)
  (*A-BRIDGE-2)
  (*A-BRIDGE-1))

(assign-smcs "broken" ADJ
  (*P-BROKEN-3 1400 1450 1550 1900 4450 4700 7300)
  (*P-BROKEN-2)
  (*P-BROKEN-1))

(assign-smcs "brush" N
  (*O-BRUSH-3)
  (*O-BRUSH-2 1400 1450 1550 1900 4450 4700 7300)
  (*O-BRUSH-1))

(assign-smcs "bucket" N
  (*O-BUCKET-2)
  (*O-BUCKET-1))

;; Context Independent

(assign-smcs "buffer" N
  (*O-BUFFER-3 1400 1450 1550 1900 4450 4700 7300)
  (*O-BUFFER-2)
  (*O-BUFFER-1))

(assign-smcs "bundle" N
  (*O-BUNDLE-2)
  (*O-BUNDLE-1))

;; Context Independent

(assign-smcs "button" N
  (*O-BUTTON-2)
  (*O-BUTTON-1 1400 1450 1900 4450 5000 7300 7400 7450))


(assign-smcs "cable" N
  (*O-CABLE-2 1400 1450 1550 1900 4450 4700 7300)
  (*O-CABLE-1))

(assign-smcs "calibrate" V
  (*A-CALIBRATE-2)
  (*A-CALIBRATE-1))

;; Context Independent

(assign-smcs "calibration" N
  (*O-CALIBRATION-2)
  (*O-CALIBRATION-1))

;; Context Independent

(assign-smcs "caliper" N
  (*O-CALIPER-2 4100 4250)
  (*O-CALIPER-1))


(assign-smcs "call" V
  (*A-CALL-2)
  (*A-CALL-1))

;; Context Independent

(assign-smcs "cancel out" V
  ;; Old/phrasal entry not in dmk41101 single-word lexicon
  (*A-CANCEL-OUT-1)
  (*A-CANCEL-OUT-2))

;; Context Independent

(assign-smcs "capacity" N
  (*O-CAPACITY-2)
  (*O-CAPACITY-1))

;; Context Independent

(assign-smcs "car" N
  (*O-CAR-2)
  (*O-CAR-1))

;; Context Independent

(assign-smcs "carrier" N
  (*O-CARRIER-2)
  (*O-CARRIER-1))

;; Context Independent

(assign-smcs "case" N
  (*O-CASE-2)
  (*O-CASE-1))

;; Context Independent

(assign-smcs "casing" N
  (*O-CASING-7)
  (*O-CASING-6)
  (*O-CASING-5)
  (*O-CASING-4)
  (*O-CASING-3)
  (*O-CASING-2)
  (*O-CASING-1))

;; Context Independent

(assign-smcs "caster" N
  (*O-CASTER-2)
  (*O-CASTER-1 4200))


(assign-smcs "catch" N
  (*O-CATCH-2)
  (*O-CATCH-1))

;; Context Independent

(assign-smcs "cell" N
  (*O-CELL-2)
  (*O-CELL-1 1400 1450 1550 1900 4450 4700 7300))

(assign-smcs "cement" N
  (*O-CEMENT-2)
  (*O-CEMENT-1))

;; Context Independent

(assign-smcs "chain" N
  (*O-CHAIN-2)
  (*O-CHAIN-1))

;; Context Independent

(assign-smcs "change" V
  (*A-CHANGE-2)
  (*A-CHANGE-1))

;; Context Independent

(assign-smcs "channel" N
  (*O-CHANNEL-6 7050 7250)
  (*O-CHANNEL-5 7450)
  (*O-CHANNEL-4 :ALL)
  (*O-CHANNEL-3 7250 7300)
  (*O-CHANNEL-2 1400 1600 7400)
  (*O-CHANNEL-1 7250 7300))

(assign-smcs "charge" N
  (*O-CHARGE-2)
  (*O-CHARGE-1 1400 1450 1550 1900 4450 4700 7300))

(assign-smcs "charge" V
  (*A-CHARGE-2)
  (*A-CHARGE-1 1400 1450 1550 1900 4450 4700 7300))

(assign-smcs "chuck" N
  (*O-CHUCK-2)
  (*O-CHUCK-1 4200))

(assign-smcs "circle" N
  (*O-CIRCLE-2)
  (*O-CIRCLE-1 6200))

(assign-smcs "circuit" N
  (*O-CIRCUIT-2)
  (*O-CIRCUIT-1 1400 1450 1550 1900 4450 4700 7300))

(assign-smcs "clamp" N
  (*O-CLAMP-2)
  (*O-CLAMP-1))

;; Context Independent

(assign-smcs "clip" N
  (*O-CLIP-2)
  (*O-CLIP-1))

;; Context Independent

(assign-smcs "closure" N
  (*O-CLOSURE-2)
  (*O-CLOSURE-1))

;; Context Independent

(assign-smcs "coil" N
  (*O-COIL-4)
  (*O-COIL-3)
  (*O-COIL-2 1400 1450 44507300 7400 7450)
  (*O-COIL-1))

(assign-smcs "column" N
  (*O-COLUMN-2 4200 4250 4300 4350)
  (*O-COLUMN-1))

(assign-smcs "compression" N
  (*O-COMPRESSION-2)
  (*O-COMPRESSION-1 1200))

(assign-smcs "condenser" N
  (*O-CONDENSER-2 1400 1450 1550 1900 4450 4700 7300)
  (*O-CONDENSER-1))

(assign-smcs "cone" N
  (*O-CONE-3)
  (*O-CONE-2)
  (*O-CONE-1))

;; Context Independent

(assign-smcs "connection" N
  (*O-CONNECTION-2)
  (*O-CONNECTION-1))

;; Context Independent

(assign-smcs "connector" N
  (*O-CONNECTOR-2)
  (*O-CONNECTOR-1))

;; Context Independent

(assign-smcs "contact" N
  (*O-CONTACT-2)
  (*O-CONTACT-1))

;; Context Independent

(assign-smcs "control" N
  (*O-CONTROL-2)
  (*O-CONTROL-1))

;; Context Independent

(assign-smcs "controller" N
  (*O-CONTROLLER-2)
  (*O-CONTROLLER-1))

;; Context Independent

(assign-smcs "converter" N
  (*O-CONVERTER-4 1050)
  (*O-CONVERTER-3 1400 1450 1550 1900 4450 4700 7300)
  (*O-CONVERTER-2 3000 4150)
  (*O-CONVERTER-1 1050 1250 ))

(assign-smcs "cord" N
  (*O-CORD-2 1400 1450 1550 1900 4450 4700 7300)
  (*O-CORD-1))

(assign-smcs "core" N
  (*O-CORE-2)
  (*O-CORE-1))

;; Context Independent

(assign-smcs "counter" N
  (*O-COUNTER-2)
  (*O-COUNTER-1))

;; Context Independent

(assign-smcs "coupling" N
  (*O-COUPLING-2)
  (*O-COUPLING-1))

;; Context Independent

(assign-smcs "crank" N
  (*O-CRANK-2)
  (*O-CRANK-1))

;; Context Independent

(assign-smcs "crown" N
  (*O-CROWN-3)
  (*O-CROWN-2)
  (*O-CROWN-1))

;; Context Independent

(assign-smcs "cup" N
  (*O-CUP-3)
  (*O-CUP-2)
  (*O-CUP-1))

;; Context Independent

(assign-smcs "curve" N
  (*O-CURVE-2)
  (*O-CURVE-1))

;; Context Independent

(assign-smcs "cushion" N
  (*O-CUSHION-3)
  (*O-CUSHION-2)
  (*O-CUSHION-1 7300))

(assign-smcs "cutoff" N
  (*O-CUTOFF-2)
  (*O-CUTOFF-1))

;; Context Independent

(assign-smcs "cutout" N
  (*O-CUTOUT-2)
  (*O-CUTOUT-1))

;; Context Independent

(assign-smcs "cutter" N
  (*O-CUTTER-4)
  (*O-CUTTER-3)
  (*O-CUTTER-2)
  (*O-CUTTER-1 6600))

(assign-smcs "cylinder" N
  (*O-CYLINDER-2)
  (*O-CYLINDER-1 1200))

(assign-smcs "damper" N
  (*O-DAMPER-2 1050)
  (*O-DAMPER-1))

(assign-smcs "day" N
  (*O-DAY-3)
  (*O-DAY-2)
  (*O-DAY-1))

;; Context Independent

(assign-smcs "deck" N
  (*O-DECK-2)
  (*O-DECK-1))

;; Context Independent

(assign-smcs "delay" N
  (*O-DELAY-2)
  (*O-DELAY-1))

;; Context Independent

(assign-smcs "deliver" V
  (*A-DELIVER-2)
  (*A-DELIVER-1))

;; Context Independent

(assign-smcs "delivery" N
  (*O-DELIVERY-4)
  (*O-DELIVERY-3)
  (*O-DELIVERY-2)
  (*O-DELIVERY-1))

;; Context Independent

(assign-smcs "detent" N
  (*O-DETENT-2)
  (*O-DETENT-1))

;; Context Independent

(assign-smcs "dial" N
  (*O-DIAL-2)
  (*O-DIAL-1))

;; Context Independent

(assign-smcs "disc" N
  (*O-DISC-2 4150 )
  (*O-DISC-1))

(assign-smcs "discharge" N
  (*O-DISCHARGE-2)
  (*O-DISCHARGE-1 1400 1450 1550 1900 4450 4700 7300))

(assign-smcs "discharge" V
  (*A-DISCHARGE-4)
  (*A-DISCHARGE-3)
  (*A-DISCHARGE-2 1400 1450 1550 1900 4450 4700 7300)
  (*A-DISCHARGE-1 1400 1450 1550 1900 4450 4700 7300))

(assign-smcs "discharged" ADJ
  (*P-DISCHARGED-2)
  (*P-DISCHARGED-1 1400 1450 1550 1900 4450 4700 7300))

(assign-smcs "disengage" V
  (*A-DISENGAGE-3)
  (*A-DISENGAGE-2)
  (*A-DISENGAGE-1))

;; Context Independent

(assign-smcs "displacement" N
  (*O-DISPLACEMENT-3)
  (*O-DISPLACEMENT-2)
  (*O-DISPLACEMENT-1))

;; Context Independent

(assign-smcs "distributor" N
  (*O-DISTRIBUTOR-3)
  (*O-DISTRIBUTOR-2 1550)
  (*O-DISTRIBUTOR-1))

(assign-smcs "divide" V
  (*A-DIVIDE-2)
  (*A-DIVIDE-1))

;; Context Independent

(assign-smcs "divider" N
  (*O-DIVIDER-4)
  (*O-DIVIDER-3 1400 1450 1550 1900 4450 4700 7300)
  (*O-DIVIDER-2)
  (*O-DIVIDER-1))

(assign-smcs "dowel" N
  (*O-DOWEL-2)
  (*O-DOWEL-1))

;; Context Independent

(assign-smcs "draw" V
  (*A-DRAW-3)
  (*A-DRAW-2)
  (*A-DRAW-1 1400 1450 1550 1900 4450 4700 7300))

(assign-smcs "dress" V
  (*A-DRESS-2)
  (*A-DRESS-1))

;; Context Independent

(assign-smcs "drill" N
  (*O-DRILL-2)
  (*O-DRILL-1))

;; Context Independent

(assign-smcs "drive" N
  (*O-DRIVE-2)
  (*O-DRIVE-1))

;; Context Independent

(assign-smcs "drive" V
  (*A-DRIVE-2)
  (*A-DRIVE-1))

;; Context Independent

(assign-smcs "driver" N
  (*O-DRIVER-2)
  (*O-DRIVER-1))

;; Context Independent

(assign-smcs "drum" N
  (*O-DRUM-2)
  (*O-DRUM-1))

;; Context Independent

(assign-smcs "duty" N
  (*O-DUTY-2)
  (*O-DUTY-1))

;; Context Independent

(assign-smcs "early" ADJ
  (*P-EARLY-2)
  (*P-EARLY-1))

;; Context Independent

(assign-smcs "enable" V
  (*A-ENABLE-3)
  (*A-ENABLE-2)
  (*A-ENABLE-1))

;; Context Independent

(assign-smcs "engage" V
  (*A-ENGAGE-3)
  (*A-ENGAGE-2)
  (*A-ENGAGE-1))

;; Context Independent

(assign-smcs "engagement" N
  (*O-ENGAGEMENT-2)
  (*O-ENGAGEMENT-1))

;; Context Independent

(assign-smcs "enter" V
  (*A-ENTER-2)
  (*A-ENTER-1))

;; Context Independent

(assign-smcs "entrain" V
  (*A-ENTRAIN-2)
  (*A-ENTRAIN-1))

;; Context Independent

(assign-smcs "equalization" N
  (*O-EQUALIZATION-2)
  (*O-EQUALIZATION-1))

;; Context Independent

(assign-smcs "extender" N
  (*O-EXTENDER-2 1350)
  (*O-EXTENDER-1))


(assign-smcs "extension" N
  (*O-EXTENSION-3)
  (*O-EXTENSION-2)
  (*O-EXTENSION-1))

;; Context Independent

(assign-smcs "eye" N
  (*O-EYE-2)
  (*O-EYE-1))

;; Context Independent

(assign-smcs "feed" N
  (*O-FEED-2)
  (*O-FEED-1))

;; Context Independent

(assign-smcs "feel" V
  (*A-FEEL-4)
  (*A-FEEL-3)
  (*A-FEEL-2)
  (*A-FEEL-1))

;; Context Independent

(assign-smcs "ferrule" N
  (*O-FERRULE-2)
  (*O-FERRULE-1))

;; Context Independent

(assign-smcs "figure" N
  (*O-FIGURE-2)
  (*O-FIGURE-1))

;; Context Independent

(assign-smcs "file" N
  (*O-FILE-2)
  (*O-FILE-1))

;; Context Independent

(assign-smcs "filler" N
  (*O-FILLER-2)
  (*O-FILLER-1))

;; Context Independent

(assign-smcs "film" N
  (*O-FILM-2)
  (*O-FILM-1))

;; ontext Independent

(assign-smcs "finger" N
  (*O-FINGER-2)
  (*O-FINGER-1))

;; Context Independent

(assign-smcs "finish" V
  (*A-FINISH-2)
  (*A-FINISH-1))

;; Context Independent

(assign-smcs "finished" ADJ
  (*P-FINISHED-2)
  (*P-FINISHED-1))

;; Context Independent

(assign-smcs "fit" V
  (*A-FIT-2)
  (*A-FIT-1))

;; Context Independent

(assign-smcs "fitting" N
  (*O-FITTING-2)
  (*O-FITTING-1))

;; Context Independent

(assign-smcs "flag" N
  (*O-FLAG-2)
  (*O-FLAG-1))

;; Context Independent

(assign-smcs "flange" N
  (*O-FLANGE-2)
  (*O-FLANGE-1))

;; Context Independent

(assign-smcs "flap" N
  (*O-FLAP-2)
  (*O-FLAP-1))

;; Context Independent

(assign-smcs "flare" N
  (*O-FLARE-2)
  (*O-FLARE-1))

;; Context Independent

(assign-smcs "flash" V
  (*A-FLASH-2 4450)
  (*A-FLASH-1))

(assign-smcs "flasher" N
  (*O-FLASHER-2)
  (*O-FLASHER-1))

;; Context Independent

(assign-smcs "flashing" N
  (*O-FLASHING-2)
  (*O-FLASHING-1))

;; Context Independent

(assign-smcs "flat" ADJ
  (*P-FLAT-2)
  (*P-FLAT-1))

;; Context Independent

(assign-smcs "flight" N
  (*O-FLIGHT-3)
  (*O-FLIGHT-2)
  (*O-FLIGHT-1))

;; Context Independent

(assign-smcs "foam" N
  (*O-FOAM-2)
  (*O-FOAM-1))

;; Context Independent

(assign-smcs "follow" V
  (*A-FOLLOW-2)
  (*A-FOLLOW-1))

;; Context Independent

(assign-smcs "foot" N
  (*O-FOOT-2)
  (*O-FOOT-1))

;; Context Independent

(assign-smcs "fork" N
  (*O-FORK-2)
  (*O-FORK-1))

;; Context Independent

(assign-smcs "four-way" ADJ
  (*P-FOUR-WAY-2 1400 1450 1550 1900 4450 4700 7300)
  (*P-FOUR-WAY-1))

(assign-smcs "fused" ADJ
  (*P-FUSED-2)
  (*P-FUSED-1 1400 1450 1550 1900 4450 4700 7300))

(assign-smcs "gallery" N
  (*O-GALLERY-2 1200)
  (*O-GALLERY-1))

(assign-smcs "gap" N
  (*O-GAP-2)
  (*O-GAP-1))


(assign-smcs "gate" N
  (*O-GATE-2 1400 1450 1550 1900 4450 4700 7300)
  (*O-GATE-1))

(assign-smcs "gear" N
  (*O-GEAR-5 1200 1300 1500 3050 3100 3150 3200 3250 3300 3400 4350)
  (*O-GEAR-4 1500 3150 3300 4050 4100 4350 5150 5400 5600)
  (*O-GEAR-3 1500 3050 3100 3150 3250 3300 4050 5150 5200 5400 5600)
  (*O-GEAR-2 1500 3050 3100 3150 3250 3300 4050 4100 5150 5400 5600)
  (*O-GEAR-1 1200 1300 3050 3100 3150 3200 3250 3300 3400 4050 4100
   5100 5200 5400 5600))

(assign-smcs "gearing" N
  (*O-GEARING-3)
  (*O-GEARING-2)
  (*O-GEARING-1))

;; Context Independent

(assign-smcs "generator" N
  (*O-GENERATOR-3)
  (*O-GENERATOR-2)
  (*O-GENERATOR-1))

;; Context Independent

(assign-smcs "get" V
  (*A-GET-2)
  (*A-GET-1))

;; Context Independent

(assign-smcs "glass" N
  (*O-GLASS-2 7250 7300)
  (*O-GLASS-1))

(assign-smcs "go off" V
  ;; Old/phrasal entry not in dmk41101 single-word lexicon
  (*A-GO-OFF-1)
  (*A-GO-OFF-2))

;; Context Independent

(assign-smcs "grade" N
  (*O-GRADE-3)
  (*O-GRADE-2)
  (*O-GRADE-1))

;; Context Independent

(assign-smcs "gravity" N
  (*O-GRAVITY-2)
  (*O-GRAVITY-1))

;; Context Independent

(assign-smcs "grinder" N
  (*O-GRINDER-2)
  (*O-GRINDER-1))

;; Context Independent

(assign-smcs "grip" N
  (*O-GRIP-2)
  (*O-GRIP-1))

;; Context Independent

(assign-smcs "groove" N
  (*O-GROOVE-2)
  (*O-GROOVE-1))

;; Context Independent

(assign-smcs "ground" N
  (*O-GROUND-2 1400 1450 1550 1900 4450 4700 7300)
  (*O-GROUND-1))

(assign-smcs "guide" N
  (*O-GUIDE-2)
  (*O-GUIDE-1))

;; Context Independent

(assign-smcs "hand" N
  (*O-HAND-2)
  (*O-HAND-1))

;; Context Independent

(assign-smcs "head" N
  (*O-HEAD-2)
  (*O-HEAD-1))

;; Context Independent

(assign-smcs "heel" N
  (*O-HEEL-2)
  (*O-HEEL-1))

;; Context Independent

(assign-smcs "high" ADJ
  (*P-HIGH-3)
  (*P-HIGH-2)
  (*P-HIGH-1))

;; Context Independent

(assign-smcs "hold" V
  (*A-HOLD-2)
  (*A-HOLD-1))

;; Context Independent

(assign-smcs "hood" N
  (*O-HOOD-2)
  (*O-HOOD-1))

;; Context Independent

(assign-smcs "housing" N
  (*O-HOUSING-7)
  (*O-HOUSING-6 5050 5100 5150 5200 5300 5350 5400 5450 5550 5600 5700)
  (*O-HOUSING-5 5050 5100 5150 5200 5300 5350 5400 5450 5550 5600 5700)
  (*O-HOUSING-4 :ALL)
  (*O-HOUSING-3 6600 6813)
  (*O-HOUSING-2 1050)
  (*O-HOUSING-1 1150 1250 1300 1400 1500 1550 3000 3050 3100 3150 3200
   3250 3300 4000 4050 4100 4350 4450))


(assign-smcs "idler" N
  (*O-IDLER-2)
  (*O-IDLER-1))

;; Context Independent

(assign-smcs "impeller" N
  (*O-IMPELLER-2 1050 1350)
  (*O-IMPELLER-1))

(assign-smcs "indicator" N
  (*O-INDICATOR-2)
  (*O-INDICATOR-1))

;; Context Independent

(assign-smcs "inhibitor" N
  (*O-INHIBITOR-2)
  (*O-INHIBITOR-1))

;; Context Independent

(assign-smcs "inlet" N
  (*O-INLET-2)
  (*O-INLET-1 1050))

(assign-smcs "insert" N
  (*O-INSERT-2)
  (*O-INSERT-1))

;; Context Independent

(assign-smcs "installation" N
  (*O-INSTALLATION-2)
  (*O-INSTALLATION-1))

;; Context Independent

(assign-smcs "installer" N
  (*O-INSTALLER-2)
  (*O-INSTALLER-1))

;; Context Independent

(assign-smcs "interference" N
  (*O-INTERFERENCE-3)
  (*O-INTERFERENCE-2 1400 1450 1550 1900 4450 4700 7300)
  (*O-INTERFERENCE-1))

(assign-smcs "introduce" V
  (*A-INTRODUCE-2)
  (*A-INTRODUCE-1))

;; Context Independent

(assign-smcs "introduction" N
  (*O-INTRODUCTION-3)
  (*O-INTRODUCTION-2)
  (*O-INTRODUCTION-1))

;; Context Independent

(assign-smcs "jack" N
  (*O-JACK-2 1900 4800 5700 7300 7400 7450)
  (*O-JACK-1))

(assign-smcs "jaw" N
  (*O-JAW-2)
  (*O-JAW-1))

;; Context Independent

(assign-smcs "jet" N
  (*O-JET-2)
  (*O-JET-1))

;; Context Independent

(assign-smcs "jump" V
  (*A-JUMP-3)
  (*A-JUMP-2)
  (*A-JUMP-1))

;; Context Independent

(assign-smcs "jumper" N
  (*O-JUMPER-2)
  (*O-JUMPER-1))


(assign-smcs "junction" N
  (*O-JUNCTION-2 1400 1450 1550 1900 4450 4700 7300)
  (*O-JUNCTION-1))

(assign-smcs "key" N
  (*O-KEY-3)
  (*O-KEY-2)
  (*O-KEY-1))

;; Context Independent

(assign-smcs "kickout" N
  (*O-KICKOUT-2)
  (*O-KICKOUT-1))

;; Context Independent
;;  
(assign-smcs "kit" N
  (*O-KIT-2)
  (*O-KIT-1))

;; Context Independent

(assign-smcs "knob" N
  (*O-KNOB-2)
  (*O-KNOB-1))

;; Context Independent

(assign-smcs "lamp" N
  (*O-LAMP-3 7250)
  (*O-LAMP-2 7250)
  (*O-LAMP-1 7300 7400 7450))

(assign-smcs "land" N
  (*O-LAND-2)
  (*O-LAND-1))

;; Context Independent

(assign-smcs "lap" N
  (*O-LAP-2)
  (*O-LAP-1))

;; Context Independent

(assign-smcs "latch" N
  (*O-LATCH-2)
  (*O-LATCH-1))

;; Context Independent

(assign-smcs "late" ADJ
  (*P-LATE-3)
  (*P-LATE-2)
  (*P-LATE-1))

;; Context Independent

(assign-smcs "lead" N
  (*O-LEAD-2)
  (*O-LEAD-1))

;; Context Independent

(assign-smcs "leg" N
  (*O-LEG-6)
  (*O-LEG-5 :ALL)
  (*O-LEG-4 :ALL)
  (*O-LEG-3 :ALL)
  (*O-LEG-2 1400 1450 1550 1900 4450 4700 7300)
  (*O-LEG-1 :ALL))

(assign-smcs "lever" N
  (*O-LEVER-2)
  (*O-LEVER-1))

;; Context Independent

(assign-smcs "light" ADJ
  (*P-LIGHT-5)
  (*P-LIGHT-4)
  (*P-LIGHT-3)
  (*P-LIGHT-2)
  (*P-LIGHT-1))

;; Context Independent

(assign-smcs "light" N
  (*O-LIGHT-9)
  (*O-LIGHT-8 4450 7300)
  (*O-LIGHT-7 1400 7300)
  (*O-LIGHT-6 1400)
  (*O-LIGHT-5 1400)
  (*O-LIGHT-4 1400 4450 7300 7400 7450 7800)
  (*O-LIGHT-3 1400)
  (*O-LIGHT-2 1400)
  (*O-LIGHT-1 1600 4450 7300 7400 7450 7800))

(assign-smcs "line" N
  (*O-LINE-5 :ALL)
  (*O-LINE-4 :ALL)
  (*O-LINE-3 1400 4450)
  (*O-LINE-2 :ALL)
  (*O-LINE-1 :ALL))

(assign-smcs "lining" N
  (*O-LINING-2)
  (*O-LINING-1))

;; Context Independent

(assign-smcs "link" N
  (*O-LINK-3 1900 4800 4450 5700 7300 7400 7450)
  (*O-LINK-2)
  (*O-LINK-1))


(assign-smcs "locate" V
  (*A-LOCATE-2)
  (*A-LOCATE-3)
  (*A-LOCATE-1))

;; Context Independent

(assign-smcs "lock" N
  (*O-LOCK-3)
  (*O-LOCK-2)
  (*O-LOCK-1))

;; Context Independent

(assign-smcs "log" N
  (*O-LOG-2)
  (*O-LOG-1))

;; Context Independent

(assign-smcs "low" ADJ
  (*P-LOW-3)
  (*P-LOW-2)
  (*P-LOW-1))

;; Context Independent

(assign-smcs "lug" N
  (*O-LUG-5)
  (*O-LUG-4)
  (*O-LUG-3)
  (*O-LUG-2 1400 1450 4800 4450 5700 7300 7400 7450)
  (*O-LUG-1))


(assign-smcs "make" V
  (*A-MAKE-4)
  (*A-MAKE-3)
  (*A-MAKE-2)
  (*A-MAKE-1))

;; Context Independent

(assign-smcs "manifold" N
  (*O-MANIFOLD-2)
  (*O-MANIFOLD-1))

;; Context Independent

(assign-smcs "mat" N
  (*O-MAT-2)
  (*O-MAT-1))

;; Context Independent

(assign-smcs "mill" V
  (*A-MILL-2)
  (*A-MILL-1))

;; Context Independent

(assign-smcs "modulate" V
  (*A-MODULATE-2)
  (*A-MODULATE-1))

;; Context Independent

(assign-smcs "module" N
  (*O-MODULE-2)
  (*O-MODULE-1))

;; Context Independent

(assign-smcs "mounting" N
  (*O-MOUNTING-2)
  (*O-MOUNTING-1))

;; Context Independent

(assign-smcs "multiply" V
  (*A-MULTIPLY-2)
  (*A-MULTIPLY-1))

;; Context Independent

(assign-smcs "needle" N
  (*O-NEEDLE-2)
  (*O-NEEDLE-1))

;; Context Independent

(assign-smcs "nipple" N
  (*O-NIPPLE-2)
  (*O-NIPPLE-1))

;; Context Independent

(assign-smcs "normally" ADV
  (*M-NORMALLY-2)
  (*M-NORMALLY-1))

;; Context Independent

(assign-smcs "nose" N
  (*O-NOSE-2)
  (*O-NOSE-1))

;; Context Independent

(assign-smcs "nozzle" N
  (*O-NOZZLE-2)
  (*O-NOZZLE-1))

;; Context Independent

(assign-smcs "order" N
  (*O-ORDER-3)
  (*O-ORDER-2)
  (*O-ORDER-1))

;; Context Independent

(assign-smcs "out-of-phase" ADJ
  (*P-OUT-OF-PHASE-2 4450)
  (*P-OUT-OF-PHASE-1))

(assign-smcs "outline" N
  (*O-OUTLINE-2)
  (*O-OUTLINE-1))

;; Context Independent

(assign-smcs "outline" V
  (*A-OUTLINE-2)
  (*A-OUTLINE-1))

;; Context Independent

(assign-smcs "overlap" N
  (*O-OVERLAP-2)
  (*O-OVERLAP-1))

;; Context Independent

(assign-smcs "overload" V
  (*A-OVERLOAD-5)
  (*A-OVERLOAD-4)
  (*A-OVERLOAD-3)
  (*A-OVERLOAD-2 1400 1450 1550 4800 4450 5700 7300 7400 7450
)
  (*A-OVERLOAD-1 1400 1450 1550 4800 4450 5700 7300 7400 7450))

;; Senses 3-5 are exclusive of senses 1,2

(assign-smcs "pack" N
  (*O-PACK-3)
  (*O-PACK-2 1550 4800 4450 5700 7300 7400 7450)
  (*O-PACK-1 1550 4800 4450 5700 7300 7400 7450))


(assign-smcs "pack" V
  (*A-PACK-2)
  (*A-PACK-1))

;; Context Independent

(assign-smcs "packing" N
  (*O-PACKING-2)
  (*O-PACKING-3)
  (*O-PACKING-1))

;; Context Independent

(assign-smcs "paddle" N
  (*O-PADDLE-2)
  (*O-PADDLE-1))

;; Context Independent

(assign-smcs "pan" N
  (*O-PAN-3)
  (*O-PAN-2)
  (*O-PAN-1))

;; Context Independent

(assign-smcs "panel" N
  (*O-PANEL-4)
  (*O-PANEL-3)
  (*O-PANEL-2)
  (*O-PANEL-1))

;; Context Independent

(assign-smcs "pass" V
  (*A-PASS-2)
  (*A-PASS-1))

;; Context Independent

(assign-smcs "patch" N
  (*O-PATCH-3)
  (*O-PATCH-2)
  (*O-PATCH-1))

;; Context Independent

(assign-smcs "pendulum" N
  (*O-PENDULUM-2)
  (*O-PENDULUM-1))

;; Context Independent

(assign-smcs "pickup" N
  (*O-PICKUP-3)
  (*O-PICKUP-2)
  (*O-PICKUP-1 1400 1450 1550 4800 4450 5700 7300 7400 7450))

;; Sense 1 and senses 2,3 are exclusive

(assign-smcs "pilot" V
  (*A-PILOT-3)
  (*A-PILOT-2)
  (*A-PILOT-1))


(assign-smcs "pivot" N
  (*O-PIVOT-2)
  (*O-PIVOT-1))

;; Context Independent

(assign-smcs "plate" N
  (*O-PLATE-4)
  (*O-PLATE-3)
  (*O-PLATE-2)
  (*O-PLATE-1))


(assign-smcs "plug" N
  (*O-PLUG-2 1400 1450 1550 1900 4450 4700 7300)
  (*O-PLUG-1))

(assign-smcs "plunger" N
  (*O-PLUNGER-2)
  (*O-PLUNGER-1))

;; Context Independent

(assign-smcs "pocket" N
  (*O-POCKET-2)
  (*O-POCKET-1))

;; Context Independent

(assign-smcs "pointer" N
  (*O-POINTER-2)
  (*O-POINTER-1))

;; Context Independent

(assign-smcs "poppet" N
  (*O-POPPET-2)
  (*O-POPPET-1))

;; Context Independent

(assign-smcs "post" N
  (*O-POST-2)
  (*O-POST-1 1400 1450 1550 1900 4450 4700 7300))

(assign-smcs "potential" N
  (*O-POTENTIAL-2 1400 1450 1550 1900 4450 4700 7300)
  (*O-POTENTIAL-1))

(assign-smcs "practice" N
  (*O-PRACTICE-2)
  (*O-PRACTICE-1))

;; Context Independent

(assign-smcs "premium" ADJ
  (*P-PREMIUM-2)
  (*P-PREMIUM-1))

;; Context Independent

(assign-smcs "preparation" N
  (*O-PREPARATION-2)
  (*O-PREPARATION-1))

;; Context Independent

(assign-smcs "present" ADJ
  (*P-PRESENT-2)
  (*P-PRESENT-1))

;; Context Independent

(assign-smcs "primer" N
  (*O-PRIMER-2)
  (*O-PRIMER-1))

;; Context Independent

(assign-smcs "produce" V
  (*A-PRODUCE-2)
  (*A-PRODUCE-1))

;; Context Independent

(assign-smcs "product" N
  (*O-PRODUCT-2)
  (*O-PRODUCT-1))

;; Context Independent

(assign-smcs "projection" N
  (*O-PROJECTION-2)
  (*O-PROJECTION-1))

;; Context Independent

(assign-smcs "property" N
  (*O-PROPERTY-2)
  (*O-PROPERTY-1))

;; Context Independent

(assign-smcs "pulse" N
  (*O-PULSE-2)
  (*O-PULSE-1 1400 1450 1550 1900 4450 4700 7300))

(assign-smcs "quality" N
  (*O-QUALITY-2)
  (*O-QUALITY-1))

;; Context Independent

(assign-smcs "rack" N
  (*O-RACK-3)
  (*O-RACK-2 1250)
  (*O-RACK-1 4100 4200 4240 4300))

;; Sense 3 won't appear until techbull.

(assign-smcs "radiation" N
  (*O-RADIATION-2)
  (*O-RADIATION-1))

;; Context Independent

(assign-smcs "ramp" V
  (*A-RAMP-2)
  (*A-RAMP-1))

;; Context Independent

(assign-smcs "ratchet" N
  (*O-RATCHET-2)
  (*O-RATCHET-1))

;; Context Independent

(assign-smcs "re-engage" V
  (*A-RE-ENGAGE-3)
  (*A-RE-ENGAGE-2)
  (*A-RE-ENGAGE-1))

(assign-smcs "reach" V
  (*A-REACH-2)
  (*A-REACH-1))

;; Context Independent

(assign-smcs "react" V
  (*A-REACT-4)
  (*A-REACT-3)
  (*A-REACT-2)
  (*A-REACT-1))

;; Context Independent

(assign-smcs "readout" N
  (*O-READOUT-2)
  (*O-READOUT-1))

;; Context Independent

(assign-smcs "receiver" N
  (*O-RECEIVER-4)
  (*O-RECEIVER-3 1800)
  (*O-RECEIVER-2)
  (*O-RECEIVER-1 7300))

(assign-smcs "recess" N
  (*O-RECESS-2)
  (*O-RECESS-1))

;; Context Independent

(assign-smcs "reclamation" N
  (*O-RECLAMATION-2)
  (*O-RECLAMATION-1 1800))

;; Senses 1/2 are exclusive

(assign-smcs "record" N
  (*O-RECORD-3 1900 4799 4459 5700 7250 7300 7400 7450)
  (*O-RECORD-2)
  (*O-RECORD-1))


(assign-smcs "reference" N
  (*O-REFERENCE-3)
  (*O-REFERENCE-2)
  (*O-REFERENCE-1))

;; Context Independent

(assign-smcs "regulation" N
  (*O-REGULATION-3)
  (*O-REGULATION-2)
  (*O-REGULATION-1))

;; Context Independent

(assign-smcs "regulator" N
  (*O-REGULATOR-2)
  (*O-REGULATOR-1))

;; Context Independent

(assign-smcs "release" N
  (*O-RELEASE-4)
  (*O-RELEASE-3)
  (*O-RELEASE-2)
  (*O-RELEASE-1))

;; Context Independent

(assign-smcs "release" V
  (*A-RELEASE-5)
  (*A-RELEASE-3)
  (*A-RELEASE-2)
  (*A-RELEASE-4)
  (*A-RELEASE-1))


;; Context Independent

(assign-smcs "relief" N
  (*O-RELIEF-2)
  (*O-RELIEF-1))

;; Context Independent

(assign-smcs "replace" V
  (*A-REPLACE-2)
  (*A-REPLACE-1))

;; Context Independent

(assign-smcs "reset" N
  (*O-RESET-2 1400 1450 1550 4800 4450 5700 7300 7400 7450)
  (*O-RESET-1))

;; Context Independent

(assign-smcs "reset" V
  (*A-RESET-6)
  (*A-RESET-5)
  (*A-RESET-4)
  (*A-RESET-3)
  (*A-RESET-2)
  (*A-RESET-1 1400 1450 1550 4800 4450 5700 7300 7400 7450))

(assign-smcs "resurface" V
  (*A-RESURFACE-2)
  (*A-RESURFACE-1))


(assign-smcs "retard" V
  (*A-RETARD-3)
  (*A-RETARD-2)
  (*A-RETARD-1))


(assign-smcs "ridge" N
  (*O-RIDGE-2)
  (*O-RIDGE-1))

;; Context Independent

(assign-smcs "rig" N
  (*O-RIG-3)
  (*O-RIG-2)
  (*O-RIG-1))

;; Context Independent

(assign-smcs "rim" N
  (*O-RIM-2)
  (*O-RIM-1 4200))

(assign-smcs "rocker" N
  (*O-ROCKER-2 1900 4800 4450 5700 7300 7400 7450)
  (*O-ROCKER-1 1200))

(assign-smcs "rod" N
  (*O-ROD-2)
  (*O-ROD-1))

;; Context Independent

(assign-smcs "roller" N
  (*O-ROLLER-2)
  (*O-ROLLER-1))

;; Context Independent

(assign-smcs "save" V
  (*A-SAVE-3)
  (*A-SAVE-2)
  (*A-SAVE-1))

;; Context Independent

(assign-smcs "scale" N
  (*O-SCALE-3)
  (*O-SCALE-2)
  (*O-SCALE-1))

;; Context Independent

(assign-smcs "scraper" N
  (*O-SCRAPER-3)
  (*O-SCRAPER-2)
  (*O-SCRAPER-1 5300 6200))


(assign-smcs "screen" N
  (*O-SCREEN-2 1400 1450 1550 1900 4450 4700 7300)
  (*O-SCREEN-1))

(assign-smcs "sealer" N
  (*O-SEALER-2)
  (*O-SEALER-1))

;; Context Independent

(assign-smcs "seam" N
  (*O-SEAM-3)
  (*O-SEAM-2)
  (*O-SEAM-1))

;; Context Independent

(assign-smcs "seat" N
  (*O-SEAT-2)
  (*O-SEAT-1 7300))

(assign-smcs "section" N
  (*O-SECTION-2)
  (*O-SECTION-1))

;; Context Independent

(assign-smcs "seize" V
  (*A-SEIZE-2)
  (*A-SEIZE-1))

;; Context Independent

(assign-smcs "sender" N
  (*O-SENDER-2)
  (*O-SENDER-1))

;; Context Independent

(assign-smcs "series" N
  (*O-SERIES-2)
  (*O-SERIES-1))

;; Context Independent

(assign-smcs "settle" V
  (*A-SETTLE-2)
  (*A-SETTLE-1))

;; Context Independent

(assign-smcs "setup" N
  (*O-SETUP-3)
  (*O-SETUP-2)
  (*O-SETUP-1))

;; Context Independent

(assign-smcs "shade" V
  (*A-SHADE-2)
  (*A-SHADE-1))

;; Context Independent

(assign-smcs "shank" N
  (*O-SHANK-2)
  (*O-SHANK-1))

;; Context Independent

(assign-smcs "shear" N
  (*O-SHEAR-3)
  (*O-SHEAR-2)
  (*O-SHEAR-1))

;; Context Independent

(assign-smcs "sheet" N
  (*O-SHEET-5 :ALL)
  (*O-SHEET-4 1400 1500 1550 1600 4450 5700)
  (*O-SHEET-3 :ALL)
  (*O-SHEET-2 1250 1300 1350 1450 1500 1700 1800 3000 3050 3100 3150
   3200 3250 3300 4000 4050 4100 4150 4200 4250 4300 4350 4800 4900
   5000 5100 5200 5300 5400 5500 5600 (:PLUS 6000) (:PLUS 7000))
  (*O-SHEET-1 1250 1300 1350 1450 1500 1700 1800 3000 3050 3100 3150
   3200 3250 3300 4000 4050 4100 4150 4200 4250 4300 4350 4800 4900
   5000 5100 5200 5300 5400 5500 5600 (:PLUS 6000) (:PLUS 7000)))

(assign-smcs "shift" N
  (*O-SHIFT-4)
  (*O-SHIFT-3)
  (*O-SHIFT-2)
  (*O-SHIFT-1))

;; Context Independent

(assign-smcs "shoe" N
  (*O-SHOE-3)
  (*O-SHOE-2 1450 1400 1550 4450)
  (*O-SHOE-1 4250 4200 4100))

(assign-smcs "shoulder" N
  (*O-SHOULDER-2)
  (*O-SHOULDER-1))
;;  
;; Context Independent

(assign-smcs "shunt" N
  (*O-SHUNT-2)
  (*O-SHUNT-1 1400 1450 1550 1900 4800 4450 5700 7300 7400 7450))

;; Shunt 1 and 2 are mutually exclusive.


(assign-smcs "sleeve" N
  (*O-SLEEVE-2)
  (*O-SLEEVE-1))

;; Context Independent

(assign-smcs "slip" V
  (*A-SLIP-2)
  (*A-SLIP-3)
  (*A-SLIP-1))

;; Context Independent

(assign-smcs "slot" N
  (*O-SLOT-4)
  (*O-SLOT-3)
  (*O-SLOT-2)
  (*O-SLOT-1))

;; Context Independent

(assign-smcs "socket" N
  (*O-SOCKET-2)
  (*O-SOCKET-1))

;; Context Independent

(assign-smcs "solid" ADJ
  (*P-SOLID-4)
  (*P-SOLID-3)
  (*P-SOLID-2)
  (*P-SOLID-1))

;; Context Independent

(assign-smcs "solution" N
  (*O-SOLUTION-2)
  (*O-SOLUTION-1))

;; Context Independent

(assign-smcs "spike" N
  (*O-SPIKE-2)
  (*O-SPIKE-1 1400 1450 1550 1900 4450 4700 7300))

(assign-smcs "spreader" N
  (*O-SPREADER-2)
  (*O-SPREADER-1))

;; Sense 2 is very rare-- let's delete it.

(assign-smcs "square" N
  (*O-SQUARE-2)
  (*O-SQUARE-1))

;; Context Independent

(assign-smcs "stack" N
  (*O-STACK-3)
  (*O-STACK-2)
  (*O-STACK-1 1050))

;; Context Independent

(assign-smcs "start" N
  (*O-START-2)
  (*O-START-1))

;; Context Independent

(assign-smcs "start" V
  (*A-START-2)
  (*A-START-1))

(assign-smcs "state" N
  (*O-STATE-2)
  (*O-STATE-1))

;; Context Independent

(assign-smcs "stem" N
  (*O-STEM-2)
  (*O-STEM-1))

;; Context Independent

(assign-smcs "step" N
  (*O-STEP-2)
  (*O-STEP-1))

;; Context Independent

(assign-smcs "stop" N
  (*O-STOP-2)
  (*O-STOP-1))

;; Context Independent

(assign-smcs "storage" N
  (*O-STORAGE-2)
  (*O-STORAGE-1))

;; Context Independent

(assign-smcs "strap" N
  (*O-STRAP-2)
  (*O-STRAP-1 1400 1450 1550 4800 4450 5700 7250 7300 7400 7450))

(assign-smcs "stream" N
  (*O-STREAM-2 1400 1450 1550 4800 4450 5700 7250 7300 7400 7450)
  (*O-STREAM-1))

(assign-smcs "string" N
  (*O-STRING-2 1550 4800 4450 5700 7250 730
0 7400 7450)
  (*O-STRING-1))

(assign-smcs "strip" N
  (*O-STRIP-2 1400 1450 1550 4800 4450 5700 7250 73007400 7450)
  (*O-STRIP-1))

(assign-smcs "subtract" V
  (*A-SUBTRACT-2)
  (*A-SUBTRACT-1))

;; Context Independent

(assign-smcs "supply" N
  (*O-SUPPLY-2 1400 1450 1550 4800 4450 5700 7250 7300 7400 7450)
  (*O-SUPPLY-1))

(assign-smcs "support" N
  (*O-SUPPORT-3)
  (*O-SUPPORT-2)
  (*O-SUPPORT-1))

;; Context Independent

(assign-smcs "surge" N
  (*O-SURGE-4)
  (*O-SURGE-3)
  (*O-SURGE-2 1400 1450 1550 4800 4450 5700 7250 7300 4700 7450)
  (*O-SURGE-1))

(assign-smcs "swage" V
  (*A-SWAGE-2)
  (*A-SWAGE-1))

;; Context Independent

(assign-smcs "tap" N
  (*O-TAP-5)
  (*O-TAP-4)
  (*O-TAP-3 1400 1450 1550 4800 4450 5700 7250 7300 7400 7450)
  (*O-TAP-2)
  (*O-TAP-1))

(assign-smcs "tap" V
  (*A-TAP-3 1400 1450 1550 4800 4450 5700 7250 7300 7400 7450)
  (*A-TAP-4)
  (*A-TAP-2)
  (*A-TAP-1))

(assign-smcs "tape" N
  (*O-TAPE-3)
  (*O-TAPE-2 7300)
  (*O-TAPE-1))

(assign-smcs "tee" N
  (*O-TEE-2)
  (*O-TEE-1))

;; Context Independent

(assign-smcs "thread" V
  (*A-THREAD-3)
  (*A-THREAD-2)
  (*A-THREAD-1))

;; Context Independent

(assign-smcs "tight" ADJ
  (*P-TIGHT-4)
  (*P-TIGHT-3)
  (*P-TIGHT-2)
  (*P-TIGHT-1))

;; Context Independent

(assign-smcs "time" N
  (*O-TIME-2)
  (*O-TIME-1))

;; Context Independent

(assign-smcs "tip" N
  (*O-TIP-2)
  (*O-TIP-1))

;; Context Independent

(assign-smcs "toe" N
  (*O-TOE-4)
  (*O-TOE-3)
  (*O-TOE-2)
  (*O-TOE-1))

;; Context Independent

(assign-smcs "tolerance" N
  (*O-TOLERANCE-2)
  (*O-TOLERANCE-1))

;; Context Independent

(assign-smcs "toughness" N
  (*O-TOUGHNESS-2)
  (*O-TOUGHNESS-1))

;; Context Independent

(assign-smcs "trace" V
  (*A-TRACE-3)
  (*A-TRACE-2)
  (*A-TRACE-1))

;; Context Independent

(assign-smcs "track" N
  (*O-TRACK-2)
  (*O-TRACK-1))

;; Context Independent

(assign-smcs "transfer" N
  (*O-TRANSFER-4 1400 1450 1550 1900 4450 4700 7300)
  (*O-TRANSFER-3)
  (*O-TRANSFER-2)
  (*O-TRANSFER-1))

(assign-smcs "travel" N
  (*O-TRAVEL-3)
  (*O-TRAVEL-2)
  (*O-TRAVEL-1))

;; Context Independent

(assign-smcs "trim" N
  (*O-TRIM-2)
  (*O-TRIM-1))

;; Context Independent

(assign-smcs "tumbler" N
  (*O-TUMBLER-2)
  (*O-TUMBLER-1))

;; Context Independent

(assign-smcs "two-way" ADJ
  (*P-TWO-WAY-3)
  (*P-TWO-WAY-2)
  (*P-TWO-WAY-1 1400 1450 1550 1900 4450 4700 7300))

(assign-smcs "undercut" N
  (*O-UNDERCUT-3)
  (*O-UNDERCUT-2)
  (*O-UNDERCUT-1))

;; Context Independent

(assign-smcs "unit" N
  (*O-UNIT-3)
  (*O-UNIT-2)
  (*O-UNIT-1))

;; Context Independent

(assign-smcs "unloading" N
  (*O-UNLOADING-2)
  (*O-UNLOADING-1))

;; Context Independent

(assign-smcs "valve" N
  (*O-VALVE-7)
  (*O-VALVE-6 3050 3100 3150 3200 3250 3300 3400 4000 4100 4250 4300
   4350 (:PLUS 5000) (:PLUS 6000) 7200)
  (*O-VALVE-5 1200 1350 1700 3050 3100 3150 3200 3250 3300 3400 4000
   4100 4250 4300 4350 (:PLUS 5000) (:PLUS 6000) 7200)
  (*O-VALVE-4 4800)
  (*O-VALVE-3 1200 1250 1300 3050 3100 3150 3200 3250 3300 3400 4000
   4100 4250 4300 4350 (:PLUS 5000) (:PLUS 6000) 7200)
  (*O-VALVE-2 1250 1300 1350 1700)
  (*O-VALVE-1 1300 1700 3050 3100 3150 3200 3250 3300 3400 4000 4100
   4250 4300 4350 4800 (:PLUS 5000) (:PLUS 6000) 7200))

(assign-smcs "volume" N
  (*O-VOLUME-2)
  (*O-VOLUME-1))

;; Context Independent

(assign-smcs "wax" N
  (*O-WAX-2)
  (*O-WAX-1))

;; Context Independent

(assign-smcs "wear" V
  (*A-WEAR-2)
  (*A-WEAR-1))

;; Context Independent

(assign-smcs "weight" N
  (*O-WEIGHT-3)
  (*O-WEIGHT-2)
  (*O-WEIGHT-1))

;; Context Independent

(assign-smcs "windrow" N
  (*O-WINDROW-2)
  (*O-WINDROW-1))

;; Context Independent

(assign-smcs "yield" V
  (*A-YIELD-2)
  (*A-YIELD-1))

;; Context Independent

(assign-smcs "yoke" N
  (*O-YOKE-2)
  (*O-YOKE-1))

;; Context Independent

;;----------------------------------------------------------------------
;; Additional data from Eric A, increment that was missing from original
;; file sent; new terms in 41101

;; Comments from Eric A:
;; Here you are, Eric. There isn't much here, as most of these guys are
;; adj and V.  They don't work very well with the SMCS. We really need to
;; start working more on the triples and the other parts of the
;; DoMo. That's where we can make some more subtle distinctions and clear
;; up the verbs and adjectives.

(assign-smcs "alert" ADJ ;; New in dmk41101
  (*P-ALERT-1)
  (*P-ALERT-2))

;; Context Independent

(assign-smcs "alternate" ADJ ;; New in dmk41101
  (*P-ALTERNATE-1)
  (*P-ALTERNATE-2))

;; Context Independent

(assign-smcs "analog" ADJ ;; New in dmk41101
  (*P-ANALOG-1)
  (*P-ANALOG-2))

;; Context Independent

(assign-smcs "angled" ADJ ;; New in dmk41101
  (*P-ANGLED-1)
  (*P-ANGLED-2))

;; Context Independent

(assign-smcs "applied" ADJ ;; New in dmk41101
  (*P-APPLIED-1)
  (*P-APPLIED-2))

;; Context Independent

(assign-smcs "area" N ;; New in dmk41101
  (*O-AREA-1)
  (*O-AREA-2)
  (*O-AREA-3)
  (*O-AREA-4)
  (*O-AREA-5))

;; Context Independent

(assign-smcs "axial" ADJ ;; New in dmk41101
  (*P-AXIAL-1)
  (*P-AXIAL-2))

;; Context Independent

(assign-smcs "backup" ADJ ;; New in dmk41101
  (*P-BACKUP-1)
  (*P-BACKUP-2)
  (*P-BACKUP-3))

;; Context Independent

(assign-smcs "bkup" N ;; New in dmk41101
  (*O-BACKUP-1))

;; Context Independent

(assign-smcs "bkup" ADJ ;; New in dmk41101
  (*P-BACKUP-1)
  (*P-BACKUP-2)
  (*P-BACKUP-3))

;; Context Independent

(assign-smcs "bore" N ;; New in dmk41101
  (*O-BORE-1)
  (*O-BORE-2))

;; Context Independent

(assign-smcs "brg" N ;; New in dmk41101
  (*O-BEARING-1)
  (*O-BEARING-2))

;; Context Independent

(assign-smcs "bypass" V ;; New in dmk41101
  (*A-BYPASS-1)
  (*A-BYPASS-2))

;; Context Independent

(assign-smcs "certain" ADJ ;; New in dmk41101
  (*P-CERTAIN-1)
  (*P-CERTAIN-2))

;; Context Independent

(assign-smcs "clear" V ;; New in dmk41101
  (*A-CLEAR-1)
  (*A-CLEAR-2))

;; Context Independent

(assign-smcs "ctrl" N ;; New in dmk41101
  (*O-CONTROL-1))

;; Context Independent

(assign-smcs "cyl" N ;; New in dmk41101
  (*O-CYLINDER-1 1000)
  (*O-CYLINDER-2))

(assign-smcs "extend" V ;; New in dmk41101
  (*A-EXTEND-1)
  (*A-EXTEND-2)
  (*A-EXTEND-3)
  (*A-EXTEND-4))

;; Context Independent

(assign-smcs "fuse" V ;; New in dmk41101
  (*A-FUSE-1)
  (*A-FUSE-2)
  (*A-FUSE-3))

;; Context Independent

(assign-smcs "heating" N ;; New in dmk41101
  (*O-HEATING-1)
  (*O-HEATING-2))

;; Context Independent

(assign-smcs "identification" N ;; New in dmk41101
  (*O-IDENTIFICATION-1)
  (*O-IDENTIFICATION-2)
  (*O-IDENTIFICATION-3))

;; Context Independent

(assign-smcs "landfill" N ;; New in dmk41101
  (*O-LANDFILL-1)
  (*O-LANDFILL-2))

;; Context Independent

(assign-smcs "level" N ;; New in dmk41101
  (*O-LEVEL-1)
  (*O-LEVEL-2)
  (*O-LEVEL-3))

;; Context Independent

(assign-smcs "liner" N ;; New in dmk41101
  (*O-LINER-1 1000)
  (*O-LINER-2))

(assign-smcs "load" N ;; New in dmk41101
  (*O-LOAD-1)
  (*O-LOAD-2 1400 1450 1550 1900 4800 4450 5700 7300 74
00 7450))

(assign-smcs "mount" V ;; New in dmk41101
  (*A-MOUNT-1)
  (*A-MOUNT-2))

;; Context Independent

(assign-smcs "mouth" N ;; New in dmk41101
  (*O-MOUTH-1)
  (*O-MOUTH-2))

;; Context Independent

(assign-smcs "move" V ;; New in dmk41101
  (*A-MOVE-1)
  (*A-MOVE-2))

;; Context Independent

(assign-smcs "option" N ;; New in dmk41101
  (*O-OPTION-1)
  (*O-OPTION-2))

;; Context Independent

(assign-smcs "pad" N ;; New in dmk41101
  (*O-PAD-1)
  (*O-PAD-2))

;; Context Independent

(assign-smcs "part" N ;; New in dmk41101
  (*O-PART-1)
  (*O-PART-2))

;; Context Independent

(assign-smcs "remote" ADJ ;; New in dmk41101
  (*P-REMOTE-1)
  (*P-REMOTE-2))

;; Context Independent

(assign-smcs "replacement" N ;; New in dmk41101
  (*O-REPLACEMENT-1)
  (*O-REPLACEMENT-2))

;; Context Independent

(assign-smcs "resistance" N ;; New in dmk41101
  (*O-RESISTANCE-1 1400 1450 1550 1900 4800 4450 5700 7
300 7400 7450)
  (*O-RESISTANCE-2))

(assign-smcs "rest" N ;; New in dmk41101
  (*O-REST-1)
  (*O-REST-2)
  (*O-REST-3))

;; Context Independent

(assign-smcs "rst" N ;; New in dmk41101
  (*O-RESET-1)
  (*O-RESET-2))

;; Context Independent

(assign-smcs "shift" V ;; New in dmk41101
  (*A-SHIFT-1)
  (*A-SHIFT-2))

;; Context Independent

(assign-smcs "sidewall" N ;; New in dmk41101
  (*O-SIDEWALL-1)
  (*O-SIDEWALL-2))

;; Context Independent


(assign-smcs "speed" N ;; New in dmk41101
  (*O-SPEED-1)
  (*O-SPEED-2))

;; Context Independent

(assign-smcs "square" ADV ;; New in dmk41101
  (*M-SQUARE-1)
  (*M-SQUARE-2))

;; Context Independent

(assign-smcs "turn" V ;; New in dmk41101
  (*A-TURN-1)
  (*A-TURN-2))

;; Context Independent

(assign-smcs "value" N ;; New in dmk41101
  (*O-VALUE-1)
  (*O-VALUE-2))

;; Context Independent

(assign-smcs "vol." N ;; New in dmk4 
  (*O-VOLUME-1)
  (*O-VOLUME-2))


