(in-package 'user)

;;;------------------------------------------------------------------;
;;; Wed Sep 15 1993 by willy
;;;
;;; The following is required in order for one of the sentences in
;;; the demo IEs to be parsed.  This is done here so that no delivery
;;; DMK files need to be changed.
;;;
;;; It makes the phrase "overspeed adjustment" count +/-
;;;
;;; However, this will not be loaded since it does not seem to better
;;; the parsing of "<callout> 4 </callout> seal screw plug for
;;; overspeed adjustment"

(setf (dmk-syn-features (first (eng-phrasal-dmk-entry "overspeed adjustment")))
      '((count (*OR* + -))))

(setf (dmk-syn-features (first (eng-phrasal-dmk-entry "natural gas")))
      '((count (*OR* + -))))

; does not have desired effect - see below version for entry "terminal"
; result is setf value of count (instead of the entry) to something else
; did not correct this one cause don't want this count - afterall
;(setf (second (assoc 'count
;		     (dmk-syn-features
;		      (find-if #'(lambda (s)
;				   (eq (dmk-pos s) 'n))
;			       (eng-dmk-entry "opss")))))
;      '-)


(let (result)
  (setf result (dmk-syn-features
		(find-if #'(lambda (s)
			     (eq (dmk-pos s) 'n))
			 (eng-dmk-entry "terminal"))))
  (setf result (remove (assoc 'count result) result :test #'equal))
  (setf result (append '((count (*OR* + -))) result))
  (setf (dmk-syn-features
		(find-if #'(lambda (s)
			     (eq (dmk-pos s) 'n))
			 (eng-dmk-entry "terminal")))
	result))

(let (result)
  (setf result (dmk-syn-features
		(find-if #'(lambda (s)
			     (eq (dmk-pos s) 'n))
			 (eng-dmk-entry "adjustment"))))
  (setf result (remove (assoc 'count result) result :test #'equal))
  (setf result (append '((count (*OR* + -))) result))
  (setf (dmk-syn-features
		(find-if #'(lambda (s)
			     (eq (dmk-pos s) 'n))
			 (eng-dmk-entry "adjustment")))
	result))