(in-package 'user)

(defun compare-smcs (new old)
  (let ((newhash (make-hash-table :size 500 :test #'equal))
	(oldhash (make-hash-table :size 500 :test #'equal))
	key (newcount 0) (oldcount 0))
    (dofile (form new)
	    (setq key (concatenate 'string
				   ;; root
				   (second form) "-"
				   ;; POS
				   (symbol-name (third form))))
	    (when (gethash key newhash)
	      (warn "Duplicate new entry, overwriting: ~a" key))
	    (incf newcount)
	    (setf (gethash key newhash) form))
    (dofile (form old)
	    (setq key (concatenate 'string
				   ;; root
				   (second form) "-"
				   ;; POS
				   (symbol-name (third form))))
	    (when (gethash key oldhash)
	      (warn "Duplicate old entry, overwriting: ~a" key))
	    (incf oldcount)
	    (setf (gethash key oldhash) form))
    (format t "~%Read ~a new entries.~%Read ~a old entries."
	    newcount oldcount)
    (maphash #'(lambda (key value)
		 (let (old)
		   (when (setq old (gethash key oldhash))
		     (unless (equal value old)
		       (format t  "~%----------------------------------------------------------------------~%Warning: old entry overwritten: ~a~%" key)
		       (print "OLD")(prin1 old)(terpri)
		       (print "NEW")(prin1 value)(terpri)
		       ))))
	     newhash)
    ))

	    
