;;; Functions for pre-handling contractions prior to parsing

; dcp decontracts and then parses using p

(defun dcp (sentence)
   (p (decontraction sentence)))

; decontraction does the actual decontraction of sentence words

(defun decontraction (sentence)  ; sentence is a list of words.
  (let ((contract-list '((i+ll i will) 
			 (you+ll you will) 
			 (he+ll he will) 
			 (she+ll she will) 
			 (it+ll it will) 
			 (we+ll we will) 
			 (they+ll they will)

			 (i+m i am) 
			 (you+re you are) 
			 (he+s he is) 
			 (she+s she is) 
			 (it+s it is) 
			 (we+re we are) 
			 (they+re they are) 

			 (i+ve i have) 
			 (you+ve you have) 
			 (he+s he has) 
			 (she+s she has) 
			 (it+s it has)
			 (we+ve we have)
			 (they+ve they have)
			 
			 (i+d i would)
			 (you+d you would)
			 (he+d he would)
			 (she+d she would)
			 (it+d it would)
			 (we+d we would)
			 (they+d they would)
			 
			 (that+s that is)
			 (what+s what is)        ; AL
			 (there+s there is )
			 ))
	(new-sentence nil))
    
    (dolist (word sentence new-sentence)
	    (setq new-sentence (concatenate 'list new-sentence
					    (if (assoc word contract-list)
						(cdr (assoc word contract-list))
					      (list word)))))))

