(in-package 'user)

;;----------------------------------------------------------------------
;; XCHART 1.1
;;
;; File: LOADER.LISP
;;
;; Last Update: 1-Apr-97 by EHN
;;
;; Copyright (c) 1996, Carnegie Mellon University, All Rights Reserved.

;; Set the right compiler flags for safe code.

#+gcl(format t "Setting compiler optimizations for GCL.")
#+gcl(proclaim '(optimize (speed 3) (safety 3) (space 0) (compilation-speed 0)))

;; Connect to the right place.

(defvar *xchart-path* "/afs/cs/project/cmt-50/xchart/1.1")
#+gcl(system:chdir *xchart-path*)
#+lucid(setf (working-directory) *xchart-path*)

;; Handy loading function.

(defun path-load (x)
  (load (format nil "~a/~a" *xchart-path* x)
	:verbose t))

;; Load DEFSYSTEM.

; (path-load "code/release/defsystem.lisp")
(path-load "code/release/defsystem-plus.lisp")

(trace compile-file make::compile-lisp-file)

(format t "Filename extensions: ~s~%" make::*filename-extensions*)

;; Set the filename extensions for GCL, if necessary.

;; #+gcl(format t "Setting make::*filename-extensions* to 'lisp', 'o'.~%")
;; #+gcl(setq make::*filename-extensions* '("lisp" . "o"))

#+GCL (setq make::*filename-extensions* '((("coda" . MAKE::COMPILE-CODA-FILE)("mor" . MAKE::COMPILE-MORPHE-FILE)("gra" . COMPILE-CHART-GRAMMAR-FILE) ("lisp" . COMPILE-LISP-FILE)) . "o"))

;; 26-Feb-98 by EHN -- added one for .lisp files, one for .gra files

(defun compile-lisp-file (filename)
  (compile-file (format nil "~A.lisp" (namestring filename))))

(defun compile-chart-grammar-file (filename)
  (compgra (namestring filename))
  (compile-file (format nil "~A.lisp" (namestring filename))))


;; Don't automatically compile -- Lucid binaries flame out on Sparc5.

#+lucid(setq make::*load-source-if-no-binary* t)

;; Set DEFSYSTEM registry.

(add-registry (format nil "~a/~a" *xchart-path* "registry"))

;; Require modules.

(new-require 'xchart)
