(in-package 'user)

;;----------------------------------------------------------------------
;; XCHART 1.0
;;
;; File: GRAMMAR.GRA
;;
;; Last Update: 14-Oct-96 by EHN
;;
;; Copyright (c) 1996, Carnegie Mellon University, All Rights Reserved.

;;----------------------------------------------------------------------
;; *LEXICON*
;;
;; Global variable holding the lexicon
;;
;; A list of lists, the first element of each list is the word and the
;; other elements are the entry-level non-terminals (lexical
;; categories) for each word in the grammar. 

(defvar *lexicon*)

;; Define the lexicon.

(setq *lexicon* '(
 (the ((cat art)(root the)))
 (large ((cat adj)(root large)))
 (can ((cat verb)(root can))((cat aux)(root can))((cat noun)(root can)))
 (holds ((cat verb)(root hold)(person 3)(number sg)))
 (water ((cat noun)(root water)))
 (man ((cat noun)(root man)))
 (in ((cat prep)(root prep)))
 (and ((cat conj)(root and)))
 (or ((cat conj)(root or)))
))

(defun deftags (list)
  (dolist (tag list)
	  (push `(,(open-tag-name tag) ((cat tag-open)(type ,tag)))
		*lexicon*)
	  (push `(,(close-tag-name tag) ((cat tag-close)(type ,tag)))
		*lexicon*)))

(defun open-tag-name (x)
  (read-from-string (format nil "<~a>" x)))

(defun close-tag-name (x)
  (read-from-string (format nil "</~a>" x)))

(deftags '(label position callout))

(defvar *tag-database*)

(setq *tag-database* 
      '(
	(noun label position)
	(fixnum callout)
))

(defun tagged-by (type cat) 
  (member type (assoc cat *tag-database*)))
