(in-package 'user)

;;----------------------------------------------------------------------
;; XCHART 1.0
;;
;; File: VARIABLES.LISP
;;
;; Last Update: 14-Oct-96 by EHN
;;
;; Copyright (c) 1996, Carnegie Mellon University, All Rights Reserved.

;;----------------------------------------------------------------------
;; *WILDCARD*
;;
;; Symbol denoting wildcard on rule RHS.

(defvar *wildcard* '$)

;;----------------------------------------------------------------------
;; *LEXICON*

(defvar *lexicon*)

;;----------------------------------------------------------------------
;; *PARSE-VALUE*
;;
;; Global variable to hold the last full parse trees.

(defvar *parse-value*)

;;----------------------------------------------------------------------
;; *PARSE-FS*
;;
;; Global variable to hold the last full parse f-structures.

(defvar *parse-fs*)

;;----------------------------------------------------------------------
;; *GLOBAL-COUNTER*
;;
;; Global variable to hold the number of agenda passes.

(defvar *global-counter*)

;;----------------------------------------------------------------------
;; *CHART*
;;
;; Global variable to hold the final chart contents.

(defvar *chart*)

;;----------------------------------------------------------------------
;; *ARCS*
;;
;; Global variable to hold the final arc list contents.

(defvar *arcs*)

;;----------------------------------------------------------------------
;; *TRACE-ARCS*
;;
;; Global variable controlling verbose arc tracing.

(defvar *trace-arcs* nil)

;;----------------------------------------------------------------------
;; *GRAMMAR*
;;
;; Global variable to hold the grammar rules.

(defvar *grammar*)

;;----------------------------------------------------------------------
;; *DEFAULT-SEARCHMODE*
;;
;; One of 'dfs, 'bfs.

(defvar *default-searchmode* 'dfs)

;;----------------------------------------------------------------------
;; *DEFAULT-QUITMODE*
;;
;; One of T, NIL.

(defvar *default-quitmode* t)

;;----------------------------------------------------------------------
;; *CHART-TRACE*
;;
;; Global variable which controls printing of trace messages
;;
;; Turned off by default.

(defvar *chart-trace* nil)

;;----------------------------------------------------------------------
;; *PRINT-PARSE-TREE*
;;
;; Global variable which controls printing of parse trees. 
;;
;; Turned on by default.

(defvar *print-parse-tree* nil)

;;----------------------------------------------------------------------
;; *PRINT-PARSE-FS*
;;
;; Global variable which controls printing of f-structures. 
;;
;; Turned on by default.

(defvar *print-parse-fs* nil)

;;----------------------------------------------------------------------
;; *OPERATIONS*
;;
;; Count the number of parse operations performed so far. 

(defvar  *operations*)

;;----------------------------------------------------------------------
;; *NODE-COUNTER*
;;
;; Unique integer id for each new entry in the chart.

(defvar *node-counter*)

;;----------------------------------------------------------------------
;; *SEARCHMODE*
;;
;; Either 'dfs or 'bfs

(defvar *searchmode*)

;;----------------------------------------------------------------------
;; *AGENDA*
;;
;; List of entries to be processed.

(defvar *agenda*)

;;----------------------------------------------------------------------