(in-package 'user)

;;----------------------------------------------------------------------
;; XCHART 1.0
;;
;; File: COMPGRA.LISP
;;
;; Last Update: 16-Oct-96 by EHN
;;
;; Copyright (c) 1996, Carnegie Mellon University, All Rights Reserved.

;;----------------------------------------------------------------------
;; COMPGRA

(defun compgra (x)
  (let ((fullname (concatenate 'string x ".gra"))
	(outfile (concatenate 'string x ".lisp"))
	(*print-pretty* nil)
	(count 0)
	fn fnbody rule level strategy)
    (with-open-file (out outfile :direction :output :if-exists :supersede)
      (format out "(DEFVAR *GRAMMAR*)~%(SETQ *GRAMMAR* NIL)~%")
      (with-open-file (in fullname :direction :input)
	(loop
	 (setq rule (read in nil in))
	 (when (eq rule in) (return))
	 (incf count)
	 (setq fn (format nil "GRAMMARF-~a" count))
	 (setq fnbody
	       (compile-augmentation (length (fourth rule))
				     (fifth rule)))
	 (setf (first fnbody) fn)
	 (setf fnbody (cons 'defun fnbody))
	 (format out "~a~%" fnbody)
	 (cond ((listp (first rule))
		(setq level (first (first rule)))
		(setq strategy (second (first rule))))
	       (t (setq level (first rule))))
	 (format out "(SETQ *GRAMMAR* (NCONC *GRAMMAR* (LIST (MAKE-RULE :STRATEGY ~s :LEVEL ~s :LHS '~s :RHS '~s :UNIFY '~a))))~%"
		 strategy level (second rule) (fourth rule) fn)
	 )))))

