// TempUpdater.java


package edu.cmu.aura.ps.examples;


import edu.cmu.aura.service.*;
import edu.cmu.aura.service.db.*;
import edu.cmu.aura.service.rpc.*;
import java.io.*;
import java.rmi.RemoteException;
import java.util.ArrayList;


/**
 * This class demonstrates how the Database may be updated 
 * using the DataSink interface.
 * 
 * @author	Glenn Judd
 * @date	10/20/2000
 */
public class TempUpdater implements Runnable {
	protected DataSinkStub		sinkStub;
	protected boolean			running;
	protected String			cityName;
	
	public TempUpdater(String hostName, int port, 
					   String cityName) throws IOException {
		sinkStub = new DataSinkStub(hostName, port);
		this.cityName = cityName;
	}
	
	public void start() {
		running = true;
		new Thread(this, "TempUpdater").start();
	}
	
	public void stop() {
		running = false;
	}
	
	public void run() {
		try {
			ArrayList			keyVal;
			ArrayList			attribs;
			Attribute			nameAttrib;
			DynamicAttribute	tempAttrib;
			double				temp;
			String				serviceName;
			
			serviceName = "City";
			temp = 0.0;
			keyVal = new ArrayList();
			nameAttrib = new Attribute("name", cityName);
			keyVal.add(nameAttrib);
			attribs = new ArrayList();
			tempAttrib = new DynamicAttribute( "temp", 
											 new Double(temp) );
			attribs.add(tempAttrib);
			
			while (running) {
				tempAttrib.setLastUpdate( System.currentTimeMillis() );
				tempAttrib.setValue( new Double(++temp) );
				try {
					System.out.print("sending update for " + cityName +"...");
					sinkStub.update(serviceName, keyVal, attribs);
					System.out.println("done.");
				} catch (RemoteException re) {
					System.out.println("remoteException occurred, ignoring");
				}
				Thread.sleep(1000);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public static void main(String[] args) {
		try {
			String	hostName;
			int		port;
			
			if (args.length < 2) {
				System.out.println("args: <hostName> <port> <cityName>...");
				return;
			}
			hostName = args[0];
			port = Integer.parseInt(args[1]);
			for (int i = 2; i < args.length; i++) {
				TempUpdater	tempUpdater;
					
				tempUpdater = new TempUpdater(hostName, port, args[i]);
				tempUpdater.start();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
}
