// SimpleInitializer.java


package edu.cmu.aura.ps.examples;


import edu.cmu.aura.service.*;
import edu.cmu.aura.service.db.*;
import java.util.ArrayList;
import org.w3c.dom.*;


/**
 * SimpleInitializer demonstrates using a DBInitializer 
 * to perform custom initialization of the Database.
 * 
 * Note that this class is compiled into aurasvc.jar so 
 * modifications will not take effect unless you take measures
 * such as changing the package or class name.
 * 
 * @author	Glenn Judd
 * @date	10/22/2000
 */
public class SimpleInitializer implements DBInitializer {
	public void initialize(Database database, Element initElement) {
		ArrayList			keyVal;
		ArrayList			attribs;
		Attribute			nameAttrib;
		Attribute			stateAttrib;
		DynamicAttribute	tempAttrib;
		
		System.out.println("Database information:");
		System.out.println( "name: "+ database.getName() );
		System.out.println( "port: "+ database.getPort() );
		nameAttrib = new Attribute("name", "Watsonville");
		stateAttrib = new Attribute("state", "California");
		tempAttrib = new DynamicAttribute("temp", new Double(70.0));
		tempAttrib.setLastUpdate( System.currentTimeMillis() );
		keyVal = new ArrayList();
		keyVal.add(nameAttrib);
		attribs = new ArrayList();
		attribs.add(stateAttrib);
		attribs.add(tempAttrib);
		try {
			database.update("City", keyVal, attribs);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
