// QueryPanel.java


package edu.cmu.aura.ps.examples;


import edu.cmu.aura.service.*;
import edu.cmu.aura.service.query.*;
import edu.cmu.aura.service.query.parser.*;
import java.awt.*;
import javax.swing.*;


/**
 * An abstract class representing a tab panel that allows
 * a query to be executed.
 * 
 * Note that this class is compiled into aurasvc.jar so 
 * modifications will not take effect unless you take measures
 * such as changing the package or class name.
 * 
 * @author	Glenn Judd
 * @date	10/22/2000
 */
public abstract class QueryPanel extends JPanel {
	protected QParser	qParser;
	
	public QueryPanel(QParser qParser) {
		this.qParser = qParser;
	}
	
	public abstract Query getQuery();
	public abstract boolean isSimpleQuery();
	
	public void execQuery(PrimitiveService pService, ResultPanel resultPanel) {
	}
}
