// GenericQueryPanel.java


package edu.cmu.aura.ps.examples;


import edu.cmu.aura.service.query.*;
import edu.cmu.aura.service.query.parser.*;
import java.awt.*;
import javax.swing.*;


/**
 * A QueryPanel that accepts text input and uses QParser
 * to turn parse the given text into a query.
 * 
 * Note that this class is compiled into aurasvc.jar so 
 * modifications will not take effect unless you take measures
 * such as changing the package or class name.
 * 
 * @author	Glenn Judd
 * @date	10/22/2000
 */
public class GenericQueryPanel extends QueryPanel {
	protected JTextField	queryField;
	
	public GenericQueryPanel(QParser qParser) {
		super(qParser);
		init();
	}
	
	protected void init() {
		GridBagLayout		gridBag;
		GridBagConstraints	c;
		
		gridBag = new GridBagLayout();
		c = new GridBagConstraints();
		setLayout(gridBag);		
		
		queryField = new JTextField();
		c.gridx = 0;
		c.gridy = 0;
		c.gridwidth = 10;
		c.gridheight = 1;
		c.weightx = 10.0;
		c.weighty = 1.0;
		c.fill = GridBagConstraints.HORIZONTAL;
		gridBag.setConstraints(queryField, c);
		add(queryField);
	}	
	
	
	public Query getQuery() {
		try {
			return qParser.parseQuery( queryField.getText() );
		} catch (QParseException qpe) {
			qpe.printStackTrace();
			return null;
		}
	}
	
	public boolean isSimpleQuery() {
		return true;
	}
}
