// ResultPanel.java


package edu.cmu.aura.ps.examples.genericClient;


import edu.cmu.aura.service.*;
import edu.cmu.aura.service.query.*;
import edu.cmu.aura.service.query.parser.*;
import java.awt.*;
import java.util.ArrayList;
import javax.swing.*;
import javax.swing.text.*;


/**
 * ResultPanel is used to display the results of a query.
 * 
 * Note that this class is compiled into aurasvc.jar so 
 * modifications will not take effect unless you take measures
 * such as changing the package or class name.
 * 
 * @author	Glenn Judd
 * @date	10/22/2000
 */
public class ResultPanel extends JPanel {
	protected JTextArea	resultArea;
	
	public ResultPanel() {
		init();
	}
	
	protected void init() {
		GridBagLayout		gridBag;
		GridBagConstraints	c;
		
		gridBag = new GridBagLayout();
		c = new GridBagConstraints();
		setLayout(gridBag);		
		
		resultArea = new JTextArea();
		c.gridx = 0;
		c.gridy = 0;
		c.gridwidth = 10;
		c.gridheight = 10;
		c.weightx = 10.0;
		c.weighty = 10.0;
		c.fill = GridBagConstraints.BOTH;
		gridBag.setConstraints(resultArea, c);
		add(resultArea);		
	}	
	
	public void clear() {
		Document	doc;
		
		doc = resultArea.getDocument();
		try {
			doc.remove( 0, doc.getLength() );
		} catch (BadLocationException ble) {
			ble.printStackTrace();
		}
	}
	
	public void displayResult(QueryResult result) {
		if (result == null) {
			resultArea.append("null result");
		} else {
			resultArea.append( "Service Time: "+ result.getTime().toString() );
			resultArea.append("\tComplete: "+ result.isComplete() +"\n");
			for (int i = 0; i < result.getNumAttribSets(); i++) {
				ArrayList	attribSet;
				
				attribSet = result.getAttributeSet(i);
				for (int j = 0; j < attribSet.size(); j++) {
					Attribute	attrib;
					String		val;
					
					attrib = (Attribute)attribSet.get(j);
					if ( attrib != null) {
						Object v;
						v = attrib.getValue();
						if (v != null) {
							val = v.toString();
						} else {
							val = "nullval";
						}
					} else {
						val = "nullattrib";
					}
					resultArea.append(val);
					resultArea.append("\t");
				}
				resultArea.append("\n");
			}
		}
	}
	
	public void append(String text) {
		resultArea.append(text);
	}
}
