// SimpleCityTempClient.java


package edu.cmu.aura.ps.examples;


import edu.cmu.aura.service.*;
import edu.cmu.aura.service.query.*;
import edu.cmu.aura.service.xml.xmlschema.*;
import java.util.ArrayList;


/**
 * CityTempClient is a simple client of the CityTemp service.
 * This class demonstrates using attribute retrieval methods
 * of PrimitiveServiceStub to perform simple attribute value
 * retrieval from a service.
 * 
 * Note that this class is compiled into aurasvc.jar so 
 * modifications will not take effect unless you take measures
 * such as changing the package or class name.
 * 
 * @author	Glenn Judd
 * @date	10/22/2000
 */
public class SimpleCityTempClient {
	protected PrimitiveServiceStub	pServiceStub;
	protected boolean				polling;
	
	/**
	 * Creates a CityTempClient.
	 * @param hostName	the hostName on which the service resides
	 * @param port	the port on which the service is listening
	 */
	public SimpleCityTempClient(String hostName, int port) throws Exception {
		pServiceStub = new PrimitiveServiceStub(hostName, port);
	}
	
	/**
	 * Queries the CityTemp service about the temperature in
	 * a single city.
	 * @param minCityName	start of the range of cities to query
	 * @param maxCityName	end of the range of cities to query
	 */
	public void displayTemp(String cityName) {
		try {
			double				temp;
			
			System.out.print("Contacting service...");
			temp = pServiceStub.getDouble("temp", "name", cityName);
			System.out.println("done.");
			System.out.println("The temperature in "+ cityName +" is "+ temp);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * Accept command line parameters from the user and run the example.
	 * @param args	command line paramters
	 */
	public static void main(String[] args) {
		try {
			SimpleCityTempClient	cityTempClient;
			String					hostName;
			int						port;
			String					cityName;
			
			if (args.length != 3) {
				System.out.println("args: <hostName> <port> <cityName>");
				return;
			}
			hostName = args[0];
			port = Integer.parseInt(args[1]);
			cityName = args[2];
			cityTempClient = new SimpleCityTempClient(hostName, port);
			cityTempClient.displayTemp(cityName);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
