// CityTempClient3.java


package edu.cmu.aura.ps.examples;


import edu.cmu.aura.service.*;
import edu.cmu.aura.service.query.*;
import edu.cmu.aura.service.xml.xmlschema.*;
import java.util.ArrayList;


/**
 * <p>
 * CityTempClient is a simple client of the CityTemp service.
 * This class demonstrates the basics of manual creation of a 
 * query, query submission, and retrieving information from a 
 * QueryResult.
 * </p>
 * 
 * <p>
 * This differs from other examples in that it users a Query
 * object to bundle the query. This provides a convenient place
 * to store query information for queries that will be repeated.
 * </p>
 * 
 * <p>
 * Note that this class is compiled into aurasvc.jar so 
 * modifications will not take effect unless you take measures
 * such as changing the package or class name.
 * </p>
 * 
 * @author	Glenn Judd
 * @date	10/22/2000
 */
public class CityTempClient3 {
	protected PrimitiveServiceStub	pServiceStub;
	protected boolean				polling;
	
	/**
	 * Creates a CityTempClient3.
	 * @param hostName	the hostName on which the service resides
	 * @param port	the port on which the service is listening
	 */
	public CityTempClient3(String hostName, int port) throws Exception {
		pServiceStub = new PrimitiveServiceStub(hostName, port);
	}
	
	/**
	 * Queries the CityTemp service about the temperature in
	 * a single city.
	 * @param minCityName	start of the range of cities to query
	 * @param maxCityName	end of the range of cities to query
	 */
	public void displayTemp(String cityName) {
		try {
			Query				query;
			QueryResult			queryResult;
			long				timeLimit;
			ArrayList			sAttribs;
			ArrayList			serviceNames;
			LeafNode			idExpression;
			DynamicAttribute	tempResult;
			double				temp;
			AttributeReq		attribReq;
				
			sAttribs = new ArrayList();
			serviceNames = new ArrayList();
			sAttribs.add("temp");
			serviceNames.add("CityTemp");
			idExpression = new LeafNode(LeafNode.OP_EQ, "name", cityName);
			timeLimit = 60000;
			System.out.print("Contacting service...");
			query = new Query(sAttribs, serviceNames, idExpression, 
							  null, timeLimit);
			queryResult = pServiceStub.query(query);
			System.out.println("done.");
			tempResult = (DynamicAttribute)
						  queryResult.getAttributeSet(0).get(0);
			temp = ((Double)tempResult.getValue()).doubleValue();
			System.out.println("The temperature in "+ cityName +" is "+ temp);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * Accept command line parameters from the user and run the example.
	 * @param args	command line paramters
	 */
	public static void main(String[] args) {
		try {
			CityTempClient3	cityTempClient;
			String			hostName;
			int				port;
			String			cityName;
			
			if (args.length != 3) {
				System.out.println("args: <hostName> <port> <cityName>");
				return;
			}
			hostName = args[0];
			port = Integer.parseInt(args[1]);
			cityName = args[2];
			cityTempClient = new CityTempClient3(hostName, port);
			cityTempClient.displayTemp(cityName);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
