// CityTempClient2.java


package edu.cmu.aura.ps.examples;


import edu.cmu.aura.service.*;
import edu.cmu.aura.service.query.*;
import edu.cmu.aura.service.xml.xmlschema.*;
import java.util.ArrayList;


/**
 * CityTempClient2 is a simple client of the CityTemp service.
 * This class demonstrates the basics of manual creation of a 
 * query, query submission, and retrieving information from a 
 * QueryResult.
 * 
 * Note that this class is compiled into aurasvc.jar so 
 * modifications will not take effect unless you take measures
 * such as changing the package or class name.
 * 
 * @author	Glenn Judd
 * @date	10/22/2000
 */
public class CityTempClient2 {
	protected PrimitiveServiceStub	pServiceStub;
	protected boolean				polling;
	
	/**
	 * Creates a CityTempClient.
	 * @param hostName	the hostName on which the service resides
	 * @param port	the port on which the service is listening
	 */
	public CityTempClient2(String hostName, int port) throws Exception {
		pServiceStub = new PrimitiveServiceStub(hostName, port);
	}
	
	/**
	 * Queries the CityTemp service about the temperature in
	 * a single city.
	 * @param cityName	city to query
	 */
	public void displayTemp(String cityName) {
		try {
			QueryResult			queryResult;
			long				timeLimit;
			ArrayList			sAttribs;
			ArrayList			serviceNames;
			LeafNode			idExpression;
			DynamicAttribute	tempResult;
			double				temp;
			AttributeReq		attribReq;
			TimeInstant			minUpdateTime;
			TimeInstant			maxUpdateTime;
			ArrayList			reqs;
				
			sAttribs = new ArrayList();
			serviceNames = new ArrayList();
			sAttribs.add("temp");
			serviceNames.add("CityTemp");
			idExpression = new LeafNode(LeafNode.OP_EQ, "name", cityName);
			timeLimit = 60000;
			System.out.print("Contacting service...");
			attribReq = new AttributeReq("temp");
			minUpdateTime = new TimeInstant(System.currentTimeMillis() - 10000);
			maxUpdateTime = new TimeInstant(System.currentTimeMillis() + 10000);
			attribReq.setUpdateTime(minUpdateTime, maxUpdateTime);
			reqs = new ArrayList();
			reqs.add(attribReq);
			queryResult = pServiceStub.query(
									sAttribs, 
									 serviceNames, 
									 idExpression,
									 reqs,//null,
									 timeLimit);
			System.out.println("done.");
			tempResult = (DynamicAttribute)
						  queryResult.getAttributeSet(0).get(0);
			temp = ((Double)tempResult.getValue()).doubleValue();
			System.out.println("The temperature in "+ cityName +" is "+ temp);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * Accept command line parameters from the user and run the example.
	 * @param args	command line paramters
	 */
	public static void main(String[] args) {
		try {
			CityTempClient2	cityTempClient;
			String			hostName;
			int				port;
			String			cityName;
			
			if (args.length != 3) {
				System.out.println("args: <hostName> <port> <cityName>");
				return;
			}
			hostName = args[0];
			port = Integer.parseInt(args[1]);
			cityName = args[2];
			cityTempClient = new CityTempClient2(hostName, port);
			cityTempClient.displayTemp(cityName);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
