// CityTempClient.java


package edu.cmu.aura.ps.examples;


import edu.cmu.aura.service.*;
import edu.cmu.aura.service.query.*;
import edu.cmu.aura.service.xml.xmlschema.*;
import java.util.ArrayList;


/**
 * CityTempClient is a simple client of the CityTemp service.
 * This class demonstrates the basics of manual creation of a 
 * query, query submission, and retrieving information from a 
 * QueryResult.
 * 
 * Note that this class is compiled into aurasvc.jar so 
 * modifications will not take effect unless you take measures
 * such as changing the package or class name.
 * 
 * @author	Glenn Judd
 * @date	10/22/2000
 */
public class CityTempClient {
	protected PrimitiveServiceStub	pServiceStub;
	protected boolean				polling;
	
	/**
	 * Creates a CityTempClient.
	 * @param hostName	the hostName on which the service resides
	 * @param port	the port on which the service is listening
	 */
	public CityTempClient(String hostName, int port) throws Exception {
		pServiceStub = new PrimitiveServiceStub(hostName, port);
	}
	
	/**
	 * Queries the CityTemp service about the temperature in
	 * a single city.
	 * @param minCityName	start of the range of cities to query
	 * @param maxCityName	end of the range of cities to query
	 */
	public void displayTemp(String cityName) {
		try {
			QueryResult			queryResult;
			long				timeLimit;
			ArrayList			sAttribs;
			ArrayList			serviceNames;
			LeafNode			idExpression;
			DynamicAttribute	tempResult;
			double				temp;
			AttributeReq		attribReq;
				
			sAttribs = new ArrayList();
			serviceNames = new ArrayList();
			sAttribs.add("temp");
			serviceNames.add("CityTemp");
			idExpression = new LeafNode(LeafNode.OP_EQ, "name", cityName);
			timeLimit = 60000;
			System.out.print("Contacting service...");
			queryResult = pServiceStub.query(
									sAttribs, 
									 serviceNames, 
									 idExpression,
									 null,
									 timeLimit);
			System.out.println("done.");
			tempResult = (DynamicAttribute)
						  queryResult.getAttributeSet(0).get(0);
			temp = ((Double)tempResult.getValue()).doubleValue();
			System.out.println("The temperature in "+ cityName +" is "+ temp);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * Accept command line parameters from the user and run the example.
	 * @param args	command line paramters
	 */
	public static void main(String[] args) {
		try {
			CityTempClient	cityTempClient;
			String			hostName;
			int				port;
			String			cityName;
			
			if (args.length != 3) {
				System.out.println("args: <hostName> <port> <cityName>");
				return;
			}
			hostName = args[0];
			port = Integer.parseInt(args[1]);
			cityName = args[2];
			cityTempClient = new CityTempClient(hostName, port);
			cityTempClient.displayTemp(cityName);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
