// CityClient.java


package edu.cmu.aura.ps.examples;


import edu.cmu.aura.service.*;
import edu.cmu.aura.service.query.*;
import edu.cmu.aura.service.rpc.*;
import java.util.ArrayList;


/**
 * CityClient is a simple client of the City service.
 * This class demonstrates the basics of manual creation of a 
 * query, query submission, and retrieving information from a 
 * QueryResult.
 * 
 * Note that this class is compiled into aurasvc.jar so 
 * modifications will not take effect unless you take measures
 * such as changing the package or class name.
 * 
 * @author	Glenn Judd
 * @date	10/22/2000
 */
public class CityClient {
	protected PrimitiveServiceStub	pServiceStub;
	protected boolean				polling;

	/**
	 * Creates a CityClient.
	 * @param hostName	the hostName on which the service resides
	 * @param port	the port on which the service is listening
	 */
	public CityClient(String hostName, int port) throws Exception {
		pServiceStub = new PrimitiveServiceStub(hostName, port);
	}
	
	/**
	 * Queries the City service about a range of cities using
	 * a single query.
	 * @param minCityName	start of the range of cities to query
	 * @param maxCityName	end of the range of cities to query
	 */
	public void displayCityInfo(String minCityName, String maxCityName) {
		try {
			QueryResult	queryResult;
			long		timeLimit;
			ArrayList	sAttribs;
			ArrayList	serviceNames;
			BoolNode	andNode;
			LeafNode	nameMin;
			LeafNode	nameMax;
				
			sAttribs = null;
			serviceNames = new ArrayList();
			serviceNames.add("City");
			nameMin = new LeafNode(LeafNode.OP_GTEQ, "name", minCityName);
			nameMax = new LeafNode(LeafNode.OP_LTEQ, "name", maxCityName);
			andNode = new BoolNode(BoolNode.OP_AND, nameMin, nameMax);
			timeLimit = 60000;
			System.out.print("Contacting service...");
			queryResult = pServiceStub.query(
									sAttribs, 
									 serviceNames, 
									 andNode,
									 null,
									 timeLimit);
			System.out.println("done.");
			for (int i = 0; i < queryResult.getNumAttribSets(); i++) {
				ArrayList	attribSet;
				
				attribSet = queryResult.getAttributeSet(i);
				for (int j = 0; j < attribSet.size(); j++) {
					Attribute	attrib;
					
					attrib = (Attribute)attribSet.get(j);
					System.out.print(attrib.getName() +": "
									   + attrib.getValue() +"\t");
				}
				System.out.println();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * Accept command line parameters from the user and run the example.
	 * @param args	command line paramters
	 */
	public static void main(String[] args) {
		try {
			CityClient	cityClient;
			String		hostName;
			int			port;
			String		minCityName;
			String		maxCityName;
			
			if (args.length != 4) {
				System.out.println("args: <hostName> <port> "
								   +"<minCityName> <maxCityName>");
				return;
			}
			hostName = args[0];
			port = Integer.parseInt(args[1]);
			minCityName = args[2];
			maxCityName = args[3];
			cityClient = new CityClient(hostName, port);
			cityClient.displayCityInfo(minCityName, maxCityName);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
