\begindata{text,539000952}
\textdsversion{12}
\template{default}
\define{footnote
}
\define{userdef
}
\define{comment
}
\majorheading{EZ -  for the Programmer}


\majorheading{\smaller{\smaller{\smaller{As published in the \italic{Linux 
Journal}, September, 1994}}}}


In this article, Terry Gliedt continues his tour through the Andrew 
project, and gives us a taste of another aspect of it; the EZ editor again, 
but this time as a source view editor for the programmer in us all.


\heading{Introduction}


AUIS had its roots in 1982 when Carnegie Mellon University and the IBM 
Corporation decided to jointly develop a campus computing facility based on 
personal computers to replace the time-sharing system then on campus.  IBM 
provided not only generous funding, but also some talented individuals and 
access to IBM development programs.


The result was a graphical user interface we know as the Andrew User 
Interface System and a file system, the \italic{Andrew File System}.  The 
file system formed the basis of Transarc Corporation's \italic{Distributed 
File System} (DFS) and is offered as part of the Open System Foundation 
software.


The \italic{\bold{Andrew Consortium}}, composed of a number of corporations 
and universities, funds the current development of AUIS.  AUIS is available 
on a wide variety of platforms including Linux, AIX, Solaris, Ultrix, HP UX 
as well as others. \



In early June, version 6.3 of the Andrew User Interface System (AUIS) was 
released by the Andrew Consortium.  This led to the release of 
\bold{auis63L0-wp.tgz} which contains just a small portion of AUIS that is 
suitable as a word processor.


Now another package has been released, \bold{auis63L0-src.tgz}, to 
\italic{sunsite.unc.edu} in \italic{/pub/Linux/X11/andrew}.  This is a set 
of additions to the word processing package to support the programmer. 
 This article will describe the support EZ provides to ease the coding and 
analysis of our programs.  Future articles in \italic{Linux Journal} will 
describe other pieces of AUIS.


\heading{EZ Views}


As a programmer, we use the same simple tool, \italic{ez}, as we did for 
word processing.  Our source program is loaded (or created) and displayed 
in a window.  But unlike \italic{ez}, the word processor, the data in the 
program source (document) does \underline{not} directly control what 
happens.  Rather the editor, \italic{ez}, actually is "aware" of the syntax 
of the source language that is being edited and provides a specialized 
\italic{\bold{view}} of the source. \



In the same way that a graph is really just a different representation of 
an array of numbers, \italic{ez} has the ability to provide unique 
\underline{views} of program source. This allows the editor to help you 
when entering the program source.  \italic{Ez} also provides assistance in 
compiling your program. Finally, \italic{ez} can help you analyze your 
program, to assist in understanding where data is referenced or where 
routines are defined.


\italic{Ez} provides support for a number of languages including assembler, 
Pascal, Modula, Lisp, C, and C++.   It provides a unique view for each 
language source file.  The view is triggered by the \underline{extension} 
of the file you edit.  For instance, \italic{\italic{ez}} will treat the 
file \bold{test.c} as a C program and will treat the file \bold{test.C} as 
a C++ program.


\heading{Entering Your Source Code}


When you first edit a C program, you will see something like that shown in 
Figure. 1. You see immediately there are many things to make the program 
easier to read:


\indent{* the include statements are in a fixed font


* comments are in a blue italized font


* special words in the language like \bold{char, int, while} etc. are in 
magenta.  These are words already recognized by the \italic{ez} view.


* function names, like \bold{main}, are in red, using a different font


* other special words, like, \bold{exit}, are in green.  These are words 
the \underline{user} defines as special.


* Strings are shown in a fixed font

}
\begindata{image,539125224}
format: gif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\enddata{image, 539125224}
\view{imagev,539125224,0,0,0}

Figure 1. Ez of Simple C Source


As you enter your code, \italic{ez} will react as soon as it figures out 
what you are coding.  In Figure 2. you can see a comment being formed. 
 Notice the color and font have already been applied, even though the 
comment is not closed.  In Figure 3. you can see how \italic{ez} handles 
pair-delimiters like (), \{\}, and [].  When you enter the trailing 
delimiters (e.g. \}) then \italic{\italic{ez}} will reverse-video the 
entire region to the matching delimiter. As you continue typing, the 
reverse-video is removed.


\begindata{image,539139464}
format: gif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\enddata{image, 539139464}
\view{imagev,539139464,1,0,0}	
\begindata{image,539142824}
format: gif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\enddata{image, 539142824}
\view{imagev,539142824,2,0,0}

Figure 2. A Comment Being Entered			Figure 3. Ez Recognizes Pair-Delimiters


\italic{Ez} will attempt to keep its view correct at all times, but you can 
confuse it.  For instance you might code a string without the comment 
delimiters and then later add the /* */ operators.  When this happens, you 
only need select the menu item \italic{Redo styles} on the \italic{Source 
Text} menu card.  This will cause the entire screen to be redrawn applying 
the view.


\italic{Ez} will also attempt to help as you enter text by automatically 
indenting your source lines as you enter them.  You do not need to enter a 
tab to indent, since \italic{ez} will do this for you automatically. 
 Unlike other aspects of the view, this \underline{does} modify the source 
since it inserts tabs to align the text.  You can also ask \italic{ez} to 
reformat your source at any time.  Simply select the area you want to 
reformat (i.e. so it is shown in reverse-video) and select the menu item 
\italic{Format line/region} on the \italic{Source Text} menu card. You can 
see the result of this action on our original source program in Figure 4. 
 One convenient feature is that when you enter a trailing delimiter (like a 
"\}"), \italic{ez} will reverse-video the region to the matching delimiter 
("\{").  If you press tab at this point, \italic{ez} will reformat the 
selected region, saving you the need to later re-select the area with the 
mouse. \



\begindata{image,539147992}
format: gif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\enddata{image, 539147992}
\view{imagev,539147992,3,0,0}

Figure 4. Automatic Indentation of Your Source


There is a great deal of tailoring that can be done to control the behavior 
of your source view. If you do not like the way \italic{ez} indents your 
source code, simply avoid the use of the \italic{Format line/region} menu 
item and your source will not be modified.  Regardless how your source 
looks, the lines of your original source are not modified unless you select 
this menu item.


Just as with a text document, \italic{ez} will automatically wrap lines 
based on the width of the window.  For instance, Figure 5. shows the same 
source as in Figure 4.  Notice the comments and source lines are re-aligned 
to make it more readable.


\begindata{image,539158744}
format: gif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\enddata{image, 539158744}
\view{imagev,539158744,4,0,0}

Figure 5. Ez Wraps Source Lines


In the past I would spend a great deal of energy making my source look 
"pretty".  It's important to me that my source look consistent since it 
makes the code much easier to read.  Since I have been using \italic{ez}, I 
no longer make any effort to format code, but rather concentrate on 
entering it. When I'm done, I reformat it with \italic{ez} and I'm done.  I 
especially like the reflowing of comments.  This has caused me to change my 
commenting style.  I seldom put comments on the same line as code any more. 
Rather I rely on \underline{paragraphs} at the beginning of a block of code 
to explain what will follow.  I much prefer this approach in coding. 
 Others may not like this style.  I use the parts of \italic{ez} that I 
find useful, and ignore the others.  I'd encourage you to do the same.



\heading{Compiling Your Code}


\italic{Ez} has support to assist you in finding compile errors.  This is 
done by invoking \italic{make}, capturing the output and then asking 
\italic{ez} to show you the source lines in error.  This is done by 
creating a second window of the source (select \italic{New Window} on the 
\italic{Window} menu card). In either of the source windows, select 
\italic{Start Compile} on the \italic{Make} menu card.  You can see the 
results in Figure 6.  When the compile completes and there are errors, 
select \italic{Next Error} on the \italic{Make} menu card.  \italic{Ez} 
will then switch files to the offending file (if necessary) and show the 
line identified in error by the compiler.  Correct the errors and start the 
process over again.


\begindata{image,539171608}
format: gif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\enddata{image, 539171608}
\view{imagev,539171608,5,0,0}	
\begindata{image,539180232}
format: gif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\enddata{image, 539180232}
\view{imagev,539180232,6,0,0}


Figure 6.  Ez Compile Support and Output from Make


\heading{Code Analysis}


Sometimes just having the editor format the source helps to understand the 
code.  The first time I used \italic{ez} on my C source, I immediately 
noticed that some \underline{code} was shown as comments.  "Ha! a bug in 
\italic{ez}", I thought.  Well, there was a bug, but not in \italic{ez}.  I 
discovered I had missed an ending comment delimiter in a program that I 
thought was working.  I actually had 10 lines of code commented out.  That 
was enough to convince me of the value of views in \italic{ez}.


\italic{Ez} is not a complete source browser in the sense of some 
commercial applications, but rather it provides a set of functions to help 
you to navigate through your source.  Sometimes you don't want to see some 
parts of your program.  Highlight that part of your program with the mouse 
and select \italic{Compress region} on the \italic{Source Text} menu card 
and you will see something like that shown in Figure 7.  If you click in 
the "compressed lines" box, the code will be shown again.  Selecting 
\italic{Decompress all} on the \italic{Source Text} menu card will expand 
all compressed source areas.

\begindata{image,539188440}
format: gif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\enddata{image, 539188440}
\view{imagev,539188440,7,0,0}

Figure 7. Ez Compresses Source Lines


The program \bold{ctags} is a program found on most Unix systems.  It will 
generate a file called \italic{tags} which contains cross-reference 
information on the functions within a set of source files.  You can also 
get cross-reference information on variables by issuing the command 
"\italic{ctags -v *.h *.c}".  \italic{Ez} can use this file to show you 
where functions or variables are defined.  Load the tags file by selecting 
the menu item \italic{Load New Tag File} or \italic{Rebuild Tag File} on 
the \italic{Tags} menu card.  To find where a variable or function is 
defined, select the variable with your mouse and select \italic{Find Tag} 
on the \italic{Tags} menu card.  \italic{Ez} will switch to the file where 
this is defined and show you the line where it is defined.



\heading{Templates}


So far we have been talking about editing \underline{existing} source 
files.  \italic{Ez} provides additional support when you edit a new, 
non-existent source file, by providing a means for you to control a 
"template" or default file.  Each language has its own template file which 
can be found in /usr/andrew/lib/tpls.  You can tailor your own by creating 
your own template directory and telling AUIS applications where your 
templates are by defining the TEMPLATEPATH environment variable.  To set 
this up, issue the following commands:


\example{mkdir $HOME/tpls

cp /usr/andrew/lib/tpls/c.tpl $HOME/tpls

export TEMPLATEPATH=$\{HOME\}/tpls:/usr/andrew/lib/tpls	# For bash/ksh

setenv TEMPLATEPATH $\{HOME\}/tpls:/usr/andrew/lib/tpls	# For csh/tcsh

}
Now you can edit your own $HOME/tpls/c.tpl template and tailor this to your 
needs.  Figure 8. shows you one such template. What you will see is much 
like a conventional program source, and indeed, it is.  This is where you 
put your own "boiler-plate" - code you'd want in most any program.  More 
interesting, however, is the existence of \bold{dogtags} (what's in a 
name?).  These are fields, delimited with "<@" and "@>", which are 
automatically substituted when the template is loaded.  For instance in 
Figure 8., you see \italic{<@name@>}, which is replaced with the name of 
the file being edited (fig1.c 
\footnote{\
\begindata{fnote,539198056}
\textdsversion{12}
which is at the end of this file\
\enddata{fnote,539198056}
\view{fnotev,539198056,8,0,0}}).  Most of these are pretty obvious.  For a 
complete list of all dogtags, see the help text shown by the command 
\bold{auishelp dogtags}. \



\begindata{image,539198856}
format: gif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\enddata{image, 539198856}
\view{imagev,539198856,9,0,379}

Figure 8. C Source Template


\heading{Controlling Colors and Fonts}


This template file also controls the colors and fonts you first saw in 
Figure 1.  While editing the template file, select \italic{Edit Styles} on 
the \italic{File} menu card. This opens a second window used to define the 
attributes of data within this template.  Start by selecting the 
\italic{<No Menu>} field in the upper left-hand corner.  To the right you 
will see keywords which correspond to aspects of the language 
(\italic{comment}, \italic{function} etc.).  Select one of these and other 
attributes like the font and size, color, spacing etc. will be shown. 
 Using these you can change any attribute you'd like.  This change will not 
become effective until you save the template and then edit a new source 
file.  It does not take effect for files which you are already editing.



\heading{Printing and Previewing}


Just as with the text documents, \italic{ez} will print the source program 
as you see it on the screen, including the fonts.  Regardless of the colors 
display your source with, printing uses a black foreground on a white 
background (as you'd expect).  The preview process uses ghostview to 
display the PostScript document that is generated.



\heading{For More Information}


A mailing list is available at info-andrew@andrew.cmu.edu (mail to 
info-andrew-request@andrew.cmu.edu for subscriptions).  The newsgroup 
comp.soft-sys.andrew is dedicated to the discussion of AUIS.  A World Wide 
Web home page can be found at 
http://www.cs.cmu.edu:8001:/afs/cs.cmu.edu/project/atk-ftp/web/andrew-home.h\
tml.  A book, \italic{Multimedia Application Development with the Andrew 
Toolkit}, has been published by Prentice-Hall (ISBN 0-13-036633-1).  An 
excellent tutorial is available from the Consortium by sending mail to 
info-andrew-request@andrew.cmu.edu and asking about the manual, \italic{A 
User's Guide to AUIS}.



\heading{About the Author, Terry Gliedt}


\begindata{image,539201096}
format: gif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\enddata{image, 539201096}
\view{imagev,539201096,10,0,0}

After spending over twenty years with IBM, Terry left Big Blue last year. 
 Although he has worked with Un*x and AUIS for over six years, he is a 
relative new-comer to Linux.  Terry does contract programming, teaches 
classes in C/C++ and Unix and writes the occasional technical document. 
 You can reach him at \italic{Software Toolsmiths}, (507) 356-4710 or by 
e-mail at \bold{tpg@mr.net}.


\begindata{bp,539201832}
Version 2
n 0
\enddata{bp,539201832}
\view{bpv,539201832,11,0,0}
\majorheading{fig1.c}


#include <stdio.h>

char *MeName = "fig1";		/* Used in msgs etc */

int Debug = 0;			/* Global debugging or not */


/*

fig1	Demonstrate what ez source views look like for the C language

              Linux Journal summer 1994 article

Copyright (c) Terry Gliedt, 1994

*/

int main (int argc, char *argv[]) \{

    /*  Scan the input parms and sort out the options.*/

    while (argv[1][0] == '-') \{

	switch (argv[1][1]) \{

	    case 'z' :

		Debug++; breask;

	    default :

		fprintf(stderr,"%s: Ignoring option '%c'\\n", MeName, argv[1][1] );

	\}

	argc--;  argv++;

    \}

    /* At this point we can decide whether tis nobler in the minds of men 
to bear the outrageous fortunes of a lack of parameters or to bail out now 
and cease our relationship. */

    if (argc < 1) \{

	Usage();

	exit(1);

    \}

	/* Put the body here. */

	if (Debug)

	return(0);

\}


\majorheading{\
\begindata{bp,539202504}
Version 2
n 0
\enddata{bp,539202504}
\view{bpv,539202504,12,0,0}
Makefile}


all:

	cc fig1.c



\majorheading{\
\begindata{bp,539202888}
Version 2
n 0
\enddata{bp,539202888}
\view{bpv,539202888,13,0,0}
c.tp}l


#include <stdio.h>

\userdef{
\userdef{char} *MeName = "<@name@>";		\comment{/* Used in msgs etc */}

int} Debug = 0;			\comment{/* Global debugging or not */}


/*

<@name@>


Function:    whatever


Syntax:

	<@name@> [-options] parms


Options:

 	z	    Enable Debug


Change Log:

  <@programmer@>	<@date@>	Initial coding


Copyright (c) <@programmer@>, <@year@>

*/


int main (int argc, char *argv[]) \{



	\comment{/*  Scan the input parms and sort out the options.*/}

	\userdef{while} (argv[1][0] == '-') \{

	\userdef{switch} (argv[1][1]) \{

	\userdef{case} 'z' :

	Debug++; \userdef{break};

	\userdef{default} :

	fprintf(stderr,"%s: Ignoring option '%c'\\n", MeName, argv[1][1] );

	\}

	argc--;  argv++;

	\}

	if (argc < 1) \{

	Usage();

	return(1);

	\}



	return(0);

\}

\enddata{text,539000952}
