ATK_INTER
#ifndef _nessview_H_
#define _nessview_H_
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
	Copyright Carnegie Mellon University 1992, 1993 - All Rights Reserved
\* ********************************************************************** */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
*/


#include <scroll.H>
#include <textview.H>

class nessview  : public  scroll {
public:
	virtual ATKregistryEntry *ATKregistry();



	void FullUpdate(enum view_UpdateType type,
			long left, long top, long width, long height);
	void Update();
	class view * Hit (enum view_MouseAction action, 
			long x, long y, long numberOfClicks);
	view_DSattributes DesiredSize(long width, long height, 
			enum view_DSpass pass, long *desiredWidth, long *desiredHeight);
	void SetDataObject(class dataobject *dobj);

	void WantInputFocus(class view *requestor);
	void ReceiveInputFocus();
	void LoseInputFocus();
	void PostMenus (class menulist *menulist);
	void PostKeyState (class keystate *keystate);
	void Print(FILE *file, char *processor, char *finalFormat, boolean topLevel);
	void ObservedChanged(class observable *changed, long value);

	virtual void FirstError();
		/* display message and highlight for first error */

	static boolean InitializeClass();
	static boolean atk_inited;
 
			/* Create default Keymap & Menus */
	
	nessview();
	virtual ~nessview();


	class textview *SourceText;	/* display the ness script */
	char *ExecFunction;		/* default function for ^X^E */
	struct errornode *CurrError;		/* which one is being displayed */

	long compmod;			/* GetModified at last compile */
	long ButtonPending;		/* used in __Hit */

	class menulist  *Menus;
	class keystate *Keystate;

	boolean MenusPostedRecently;	/* internal to PostMenus, RcvIF,  */
	boolean KeystatePostedRecently; 	/*    and FullUpdate  */

	boolean HasIF;
	boolean ErrorHighlightPending;

	boolean inverted;
	boolean dialogboxup;
	boolean justscanned;	/* if most recent compile was a scan */
	textviewInterface *ti;
};

#endif /* _nessview_H_ */
