#ifndef _asmtext_H_
#define _asmtext_H_
/* File asmtext.H created by R S Kemmetmueller
   (c) Copyright IBM Corp.  1988-1995.  All rights reserved.

$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $


   asmtext: a text subclass specialized for dealing with Assembly code. */

#define MAX_BANGCHARS 32 /* arbitrary limit for how many chars can be bang-comment-starters */
#define MAX_TABSTOPS  80 /* arbitrary number for how many Tab Stops can be set in preferences */

#include "srctext.H"
class asmtext: public srctext {
  public:
    virtual ATKregistryEntry *ATKregistry();

    long Indent(mark *range);
    char * Keywordify(char *buff, boolean checkforceupper);
    void RedoStyles();
    void SetAttributes(struct attributes *atts);

    inline void SetCComments(boolean newValue) { (((this)->CComments) = (newValue)); }
    inline boolean UseCComments() { return ((this)->CComments); }
    inline boolean HasReindentFilter() { return ((this)->reindentFilterName!=NULL && *((this)->reindentFilterName)!='\0'); }
    inline char *ReindentFilterName() { return ((this)->reindentFilterName); }

    static boolean InitializeClass();
    asmtext();

    boolean CComments;
    char bangComments[MAX_BANGCHARS+1];
    char *reindentFilterName;
};

#endif /* _asmtext_H_ */
