@make (slides)
@begin(format)

@MajorHeading(Video)

Drawbacks of most of the work in the field: recognizers are
handcoded, or use neural nets that are expensive to
train & execute.

My primary result:
@begin(itemize)
I have automated the process of building gesture recognizers

Recognizers trainable with a few examples per gesture.

Executing in real-time on a MicroVAX II

Each application about to be shown has a click-and-drag
interfaces `coded' into it.  The entire gestural interface
was added at runtime, and can be turned on and off at will.
@end(itemize)

GDP 
@begin(itemize)
Gesture-based version of DP

MACH/UNIX, MicroVAX II, X10, Objective C

Uses no keyboard, single mouse button
@end(itemize)

GSCORE - musical score editor

Eager recognition

MDP, Multi-finger DP, Silicon Graphics IRIS, C

@newpage

@MajorHeading(Contributions)

I have made contributions in four areas:

@Heading[New interaction techniques]
@begin(itemize)
Single-stroke gesture with manipulation

Eager recognition

Multi-path gesture with manipulation
@end(itemize)

@Heading[New recognition-related algorithms]

@begin(itemize)
Automatic generation of single-stroke gesture recognizers

Incremental feature calculation

Automatic generation of eager recognizers

Automatic generation of multi-path gesture recognizers

Algorithm for rejecting outlying and ambiguous gestures
@end(itemize)

@Heading[Integrating gestures into interfaces]

@begin(itemize)
Gestures associated with view or view class

Gesture set dynamically determined by both
inheritance up the class hierarchy and by
currently overlapping views

Gesture class and attributes map to application operations and parameters

Runtime creation, deletion, and manipulation of gesture handler,
gesture classes, gesture examples, and  gesture semantics
@end(itemize)

@Heading[Input in Object-Oriented Toolkits]
@begin(itemize)
Passive & active event handlers

Event handlers associated with views or view classes, inherited

Unified mouse input and virtual tools

Automatic semantic feedback

Runtime creation and manipulation of event handlers

@end(itemize)

@newpage

@begin(comment)
@MajorHeading()
@newpage
@end(comment)
@end(format)
