@make (slides)
@begin(format)

@MajorHeading(Outline)
@begin(itemize)
What are gestures and why are they good?

Related Work

Motivation for this work

Gesture Recognition
@begin(itemize)
	Single Path

	Eager Recognition

	Multiple Path
@end(itemize)

Object-Oriented User Interface Toolkits
@begin(itemize)
	GRANDMA

	Gesture Handling in GRANDMA
@end(itemize)

Evaluation

Future Directions

Conclusion

Questions?
@end(itemize)
@newpage

@MajorHeading(Motivation)

Gesture-based systems are hard to build.

@begin(itemize)
Recognition

Integration into applications
@end(itemize)






@b(Goal:)

Make it easy to add gestures to an interface.

@newpage

@MajorHeading(Recognition)

@begin(itemize)
Application independent

Trainable by a few examples per gesture

Fast, accurate, efficient recognition

Fast training and retraining

Allows some gestures to vary in
size, orientation, and dynamics

Single path or multiple paths

Extensible

Eager recognition

@end(itemize)

@newpage

@MajorHeading(Easy integration)

@begin(itemize)
Give examples of each gesture

Associate sets of gestures with objects

Incorporate gesture semantics without recompilation
@end(itemize)



After recognition allow for manipulation

@begin(itemize)
	Collection [Recognition] Manipulation

	``One-shot'' parameters at recognition time

	Continuous feedback during manipulation
@end(itemize)

@newpage

@MajorHeading(Features)
@begin(itemize)
	Small number

	Meaningful

	Incrementally updated (constant time per input point)

	Extensible

	Gaussian-like
@end(itemize)


@newpage

@MajorHeading(Classification)

(Duda & Hart, 1973, p27-29)

If you assume

@begin(itemize)
	per-class feature vectors have
	multivariate-normal distribution

	common covariance matrix

	equal prior probabilities

	equal misclassification costs
@end(itemize)

then there is a closed form solution for
determining the optimal linear classifier.

Quick training:
@begin(itemize)
Estimate per-class mean

Estimate common-covariance matrix

Invert covariance matrix

Multiply by means to get weights
@end(itemize)


@newpage

@MajorHeading(Rejection)

A gesture may be rejected if it is ambiguous or
an outlier.


Probability of Ambiguity












Mahalanobis distance from mean of chosen class












@newpage


@MajorHeading(Eager Recognition)

Typically, collecting a gesture is done when
@begin(itemize)
the user explicitly indicates it

no motion occurs for a given time interval

@end(itemize)

Sometimes, a ``smoother'' interaction can be had if 
the gesture is classified as soon as enough of it has
been seen to do so unambiguously.



(video)
@newpage

@MajorHeading(Multi-Path Recognition)

@begin(itemize)
Multi-finger devices:
@begin(itemize)
Data-glove (and relatives)

Sensor Frame

Multi-finger touch pads
@end(itemize)

More natural and expressive gestures

More independent parameters to manipulate
@end(itemize)





(video)
@newpage

@MajorHeading(Sensor Frame)


Delivers x,y coordinates of up to three fingers
30 times per second.

No path tracking.


No indication of which finger is which.

@newpage

@MajorHeading(Changing Semantics)

@begin(verbatim)
recog = 
 [_Seq :[handler mousetool:
		  <createLineCursor>]

       :[topview thickness:
	     [[<pathlength>
		 dividedBy:40]
                    Clip :1 :9]]

       :[[topview createLine]
	     translateEndpoint:0
                x:<startx>
		y:<starty>]
 ];


manip =
  [recog scaleXYendpoint:1
     x:<currentX>
     y:<currentY>
     cx:<startX>
     cy:<startY>];


done = [];

@end(verbatim)

@newpage
@MajorHeading(Summary)

@begin(itemize)
New interaction techniques:
@begin(itemize)
Single-stroke gesture with manipulation

Eager recognition

Multi-path gesture with manipulation
@end(itemize)

Low level recognition:
@begin(itemize)
Application Independent

Fast, accurate recognition

Trainable by small number of examples per gesture

Recognizer size is independent of the number of examples

Meaningful features

Dynamic features

Extensible feature set

Incremental feature calculation

Handles variations in size and orientation of some gestures

Rejects outliers and ambiguous gestures

Training examples may be added or deleted incrementally
@newpage
@MajorHeading(Summary, cont.)

Retraining time is independent of the number of examples

Classifiers are robust in the presence of occasional bad training data

Classifier useful for eager recognition

Extended to multi-path recognition
@end(itemize)

Integrating gestures into interfaces:
@begin(itemize)

Gestures set associated with view or class

Gestures inherited via the class hierarchy

Gesture set dynamically determined

Lazy training with caching

Gesture class and attributes map to application operations and parameters

Runtime creation, deletion, and manipulation of:
@begin(itemize)
gesture handlers

gesture classes

gesture examples

gesture semantics
@end(itemize)
@end(itemize)
@newpage
@MajorHeading(Summary, cont.)

GRANDMA
@begin(itemize)
Event handlers associated with views or view classes

Event handler can be shared

Multiple input devices 

Multi-threaded dialogue

Unifies input and virtual tools

Semantics feedback

Runtime creation and manipulation of event handlers
@begin(itemize)
Association with views

Event-handling predicates
@end(itemize)

@end(itemize)


@end(itemize)

@newpage

@begin(comment)
@end(comment)
@end(format)


