@make (slides)
@begin(format)
@newpage
@Heading[
The
Automatic Recognition
of
Gestures
]


@Heading(Dean Rubine)






@Heading(Committee)
Roger Dannenberg
Dario Giuse
Brad Myers
Bill Buxton, University of Toronto & Xerox PARC

@newpage
@MajorHeading(Outline)
@begin(itemize)
What are gestures and why are they good?

Related Work

Motivation for this work

Gesture Recognition
@begin(itemize)
	Single Path

	Eager Recognition

	Multiple Path
@end(itemize)

Object-Oriented User Interface Toolkits
@begin(itemize)
	GRANDMA

	Gesture Handling in GRANDMA
@end(itemize)
Evaluation

Future Directions

Conclusion

Questions?
@end(itemize)
@newpage

@MajorHeading(What is a Gesture?)

@begin(itemize)
``Expressive Motion''

Motion: Generalized Pointing
@begin(itemize)
	Pointing =
		Single point at a single instant

	Single-path gesture =
		Single point over time

	Multi-path gesture =
		Multiple paths over time

	(Posture =
		Multiple points at a single instant)
@end(itemize)

Meaning

@end(itemize)
	
@newpage

@MajorHeading(Why are gestures good?)

Intuitive

A single gesture communicates
@begin(itemize)
An object or objects

An operation

Additional parameters
@end(itemize)

Physical tension corresponds to mental tension (Buxton)

@newpage

@MajorHeading(Related Work)
@begin(itemize)
Input Devices

Pattern Recognition

User Interface Construction Technologies

Previous Gesture-based systems
@begin(itemize)
@tabclear()
@tabset(2in)
Proofreader's marks @\ Coleman (1969)

Char-Rec/SSSP (Buxton, Sniderman, Reeves, Patel and Baecker, 1979)

Button Box (Minsky, 1984)

PLI (Wolf, Rhyne, Kim, Tappert, Fox, Levy, and Zimmerman, 1985-)

Flowcharts (Murase and Wakahara, 1988)

Sign Language (Tamura and Kawasaki, 1988)

Glove-Talk (Fels & Hinton, 1990)
@end(itemize)
@end(itemize)


(video)

@newpage

@MajorHeading(Motivation for this dissertation)

@begin(itemize)
Gesture-based systems are hard to build.
@begin(itemize)
Recognition

Integration into applications
@end(itemize)
Goal: Adding gestures to an application should be easy
@begin(itemize)
Specify examples of each class

Associate sets of classes with objects

Write gesture semantics
@begin(itemize)
Operation <=> class

object <=> location

parameters <=> gestural attributes
@end(itemize)
@end(itemize)
Allow for experimentation.

Synthesize recognition and direct-manipulation
@begin(itemize)
	Collection [Recognition] Manipulation

	``One-shot'' parameters at recognition time

	Continuous feedback during manipulation
@end(itemize)

@end(itemize)

@newpage


@MajorHeading(Single-Path Gesture Recognition)
@begin(itemize)
Single strokes

Dynamic attributes

Accurate

Trained by a small number of examples per class

Allows variation in size and orientation

Recognizer size independent of the number of examples

Fast recognition

Fast training

Feature-based
@begin(itemize)
	Small number

	Meaningful

	Incrementally updated (constant time per input point)

	Extensible

	Gaussian-like
@end(itemize)

Fast retraining
@end(itemize)

@newpage

@MajorHeading(Features)
@begin(itemize)
Initial angle (sine and cosine)

Length of the bounding box diagonal

Angle of the bounding box diagonal

Distance between the first and last point

Angle between first and last point (cosine and sine)

Cosine and sine of angle between first and last point

Total gesture path length

Total angle (sum of angle at each point)

Sum of absolute angle at each point

Sum of squared angle at each point (sharpness)

Maximum speed 

Path duration

@end(itemize)


@newpage

@MajorHeading(Classification)

Assumes

@begin(itemize)
	per-class feature vectors have
	multivariate-normal distribution

	common covariance matrix.
@end(itemize)




Closed form solution
@begin(itemize)

Linear evaluation functions per class

Quick training
@begin(itemize)
Estimate per-class mean

Estimate common-covariance matrix

Invert covariance matrix matrix

Multiply by means to get weights
@end(itemize)

@end(itemize)


@newpage

@MajorHeading(Rejection)

Probability of Ambiguity








Mahalonobis distance from mean of chosen class









@newpage


@MajorHeading(Eager Recognition)

Typically, collecting a gesture is done when
@begin(itemize)
the user explicitly indicates it

no motion occurs for a given time interval

@end(itemize)

Sometimes, a ``smoother'' interaction can be had if 
the gesture is classified as soon as enough of it has
been seen to do so unambiguously.



(video,algorithm)
@newpage

@MajorHeading(Multi-Path Recognition)

@begin(itemize)
Multi-finger devices:
@begin(itemize)
Data-glove (and relatives)

Sensor Frame

Multi-finger touch pads
@end(itemize)

More natural and expressive gestures

More independent parameters to manipulate
@end(itemize)





(video,algorithm)
@newpage

@MajorHeading(GRANDMA)

@begin(center)
``Gesture Recognizers Automated
in a
Novel Direct Manipulation Architecture''
@end(center)

@begin(itemize)
Model/View/Controller-based

Generalized Input Architecture

Virtual Tools

Semantic Feedback
@end(itemize)

@newpage

@MajorHeading(Gesture Handling in GRANDMA)

@begin(itemize)
Gesture Handler
@begin(itemize)
Encapsulates a set of gesture
classes and their semantics
	
Associated with a view or an entire view class

Searches superclasses and ``underneath'' views

@end(itemize)

Runtime creation & manipulation of:
@begin(itemize)
	Gesture Handlers

	Gesture classes

	Gesture class semantics

	Gesture class examples
@end(itemize)


@end(itemize)






(video)


@newpage

@MajorHeading(Applications)

@begin(itemize)
	GDP 
@begin(itemize)
		Drawing editor

		Single-path gestures

		2 handlers, 11 gestures
@end(itemize)

	GSCORE
@begin(itemize)
		Score editor

		Single-path gestures

		3 handlers, 30 gestures
@end(itemize)
	MDP
@begin(itemize)
		Drawing editor

		multi-path gestures

		not GRANDMA-based
@end(itemize)
@end(itemize)


@newpage
@MajorHeading(Evaluation)
@begin(itemize)
	Recognition Rates
@begin(itemize)
		GSCORE

		Varying size and orientation
@end(itemize)
	Rejection
	
	Timings

	User Study
@end(itemize)
@newpage

@MajorHeading(Timings)

@heading(Calculating Features)
@tabclear()
@tabset(1.2in,2.2in,3.2in,4.2in,5.2in,6.2in)

Proc @\ milliseconds per call
@\ Point @\ Calc @\ CalcFeatures
uVAX II @\ 0.22 @\ 0.34 @\ 3.9
uVAX III @\ 0.074 @\ 0.13 @\ 1.3 
3100 @\ 0.029 @\ 0.040 @\ 0.44

@heading(Classification)
Proc @\ Computation time (milliseconds)
@\ eval  @\ max @\ ambig  @\ dist @\ total
@\ (1C) @\ (30C)
uVAX II  @\ 0.27  @\ 8.0  @\ 0.8   @\ 3.7  @\ 12.6
uVAX III @\ 0.074 @\ 2.2 @\ 0.3  @\ 1.1  @\ 3.6
3100  @\ 0.022 @\ 0.66 @\ 0.01  @\ 0.26 @\ 0.99

@heading(Training)
Proc @\ Time (milliseconds per call)
 @\ AddEx @\ RemEx @\ Train @\ Train
 @\  @\ @\ (10C) @\ (30C)
uVAX II @\ 3.7 @\ 3.8 @\ 130 @\ 234 
uVAX III @\ 0.90 @\ 0.90 @\ 43 @\   78 
3100 @\ 0.024 @\ 0.026 @\ 14 @\   22

@newpage
@MajorHeading(Future Work)
@begin(itemize)

	Improve classifier
@begin(itemize)
		Fix features

		New features
@end(itemize)

	Incorporate gestures:
@begin(itemize)
		Garnet

		ATK

		MacApp

		NeXT AppKit
@end(itemize)

@end(itemize)


@newpage

@MajorHeading(Conclusion)

It is possible to make tools that support the
simple integration of gestures into existing
applications built from object-oriented toolkits.

 
Gesture recognition may be done simply, cheaply,
accurately, and flexibly in an application
independent manner.


Performance on today's machines is sufficent to allow
experimentation with gesture-based systems.


@newpage

@begin(comment)
@end(comment)
@end(format)


