/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/util/lib/RCS/wpstat.c,v 2.11 1993/02/12 21:23:32 rr2b Exp $";
#endif

/* ************************************************************ *\
	wpstat.c
	The wp_ErrorString function.
	Include file ``wp.h'' declares the procedures for clients.
\* ************************************************************ */

#include <andyenv.h>
#include <stdio.h>
#include <andrewos.h>		/* sys/file.h */
#include <ctype.h>
#include <errno.h>
#include <truth.h> /* itc.h -> truth.h DMT */
#include <pwd.h>
#include <util.h>
#ifdef WHITEPAGES_ENV  /* avoid makedepend "errors" */
#include <bt.h>
#include <wp.h>
#include <btwp.h>
#endif /* WHITEPAGES_ENV   */
extern int errno;

/* gives static English text interpreting an error code value */
char *wp_ErrorString(codevalue)
wp_ErrorCode codevalue;
{
    static char *WPErrs[wperr_MAX + 1 + 1] = {
	"Not an error",
	"Out of memory",
	"No keys found",
	"Too many keys found",
	"No such key",
	"Key error",
	"No such field",
	"Indeterminate result",
	"Field index out of bounds",
	"No such token kind",
	"Token malformed",
	"Function not implemented",
	"Internal error",
	"Undifferentiated file system error",
	"Undifferentiated Grits error",
	"Undifferentiated B-tree error",
	"B-tree temporary inconsistency",
	"B-tree index includes missing record",
	"Non-cell compatibility routine called before wp_Initialize",
	"Argument is not of wp_cd type",
	"White Pages are for the wrong cell",
	"No primary authentication to use for default cell",
	NULL };
	static char WPErrBuff[120];

	if (codevalue <= wperr_MAX && codevalue >= 0) return WPErrs[codevalue];
	if (codevalue >= wperr_FileSystemErrorBegin &&
	    codevalue <= wperr_FileSystemErrorEnd) {
	    sprintf(WPErrBuff, "White pages: %s",
		    UnixError(codevalue - wperr_FileSystemErrorBegin));
	    return WPErrBuff;
	}
	if (codevalue >= wperr_BTreeBaseValue
	    && codevalue < (wperr_BTreeBaseValue + bterr_FileSystemErrorBegin)) {
	    sprintf(WPErrBuff, "B-tree: %s",
		    bt_ErrorString(codevalue - wperr_BTreeBaseValue));
	    return WPErrBuff;
	}
	if (codevalue >= (wperr_BTreeBaseValue + bterr_FileSystemErrorBegin)
	    && codevalue <= (wperr_BTreeBaseValue + bterr_FileSystemErrorEnd)) {
	    return bt_ErrorString(codevalue - wperr_BTreeBaseValue);
	}
	sprintf(WPErrBuff, "White Pages error code %d", codevalue);
	return WPErrBuff;
}
