/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/util/lib/RCS/wpcbase.c,v 2.14 1993/02/12 21:23:32 rr2b Exp $";
#endif

/* ************************************************************ *\
	wpcbase.c
	Compatibility routines that choose a cell to use.
	Include file ``wp.h'' declares the procedures for clients.
\* ************************************************************ */

#include <andyenv.h>
#include <stdio.h>
#include <andrewos.h>		/* sys/file.h sys/types.h sys/time.h strings.h */
#include <ctype.h>
#include <errno.h>
#include <truth.h> /* itc.h -> truth.h DMT */
#include <sys/stat.h>
#include <pwd.h>
#include <util.h>
#ifdef WHITEPAGES_ENV  /* avoid makedepend "errors" */
#include <bt.h>
#include <wp.h>
#include <btwp.h>
#endif /* WHITEPAGES_ENV   */
#include <svcconf.h>

extern int errno;

/* Compatibility routines for non-cellular use */
struct wp_CD *ThisCellDir = NULL;

wp_ErrorCode wp_Initialize()
{
    wp_ErrorCode wpErr;
    /* char DomainName[200]; */
    int rc;

    if (ThisCellDir != NULL && ThisCellDir->Tag != wpcdTag) ThisCellDir = NULL;
    if (ThisCellDir == NULL) {	/* Need to default this from somewhere. */
	CheckServiceConfiguration();
	/* rc = GetCurrentWSCell(DomainName, sizeof(DomainName)); */
	/* if (rc != 0) return (rc + wperr_FileSystemErrorBegin); */
	/* Try to get the WP for this domain. */
	/* wpErr = wp_InitializeCell(DomainName, (struct wp_cd **) &ThisCellDir); */
	wpErr = wp_InitializeCell(ThisDomain, (struct wp_cd **) &ThisCellDir);
	return wpErr;	/* First initialization: Done as much as possible. */
    }

    /* Subsequent times: just bump the use count. */
    ++(ThisCellDir->TimesInited);
    return wperr_NoError;
}

wp_ErrorCode wp_Terminate()
{
    int OldInited;
    wp_ErrorCode res;

    if (ThisCellDir == NULL) return wperr_NotInited;
    OldInited = ThisCellDir->TimesInited;
    res = cwp_Terminate((struct wp_cd *) ThisCellDir);
    if (OldInited <= 1) ThisCellDir = NULL;	/* Was freed */
    return res;
}

wp_ErrorCode wp_GetNIDOnly(NID, PKPtr)
int NID; wp_PrimeKey *PKPtr;
{
    if (ThisCellDir == NULL) return wperr_NotInited;
    return cwp_GetNIDOnly((struct wp_cd *) ThisCellDir, NID, PKPtr);
}

wp_ErrorCode wp_GetUIDOnly(UID, PKPtr)
char *UID; wp_PrimeKey *PKPtr;
{
    if (ThisCellDir == NULL) return wperr_NotInited;
    return cwp_GetUIDOnly((struct wp_cd *) ThisCellDir, UID, PKPtr);
}

wp_ErrorCode wp_Read(PKey, FieldIx, FValPtr)
wp_PrimeKey PKey; wp_FieldIndex FieldIx; char **FValPtr;
{
    if (ThisCellDir == NULL) return wperr_NotInited;
    return cwp_Read((struct wp_cd *) ThisCellDir, PKey, FieldIx, FValPtr);
}
