/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/util/lib/RCS/venusop.c,v 2.10 1992/12/15 21:11:36 rr2b R6tape $";
#endif

/*

	venusop.c -- routines that are specific to Vice file system, doing Venus operations

	VenusFlush(pathname): take a pathname and do an ``fs flush'' op.

	VenusFetch(pathname): take a pathname and pre-fetch it.

	VenusCancelStore(fid): prevent the close(fid) from storing the file.

	VenusFlushCallback(pathname): flush the callback, but not the data, for the named file.

	All routines return the result of the pioctl/ioctl and leave error codes in errno.
*/

#include <andrewos.h>
#include <errno.h>
#include <stdio.h>
#include <sys/ioctl.h>
#ifdef AFS_ENV
#include <netinet/in.h>
#include <afs/param.h>
#include <afs/venus.h>
#endif /* AFS_ENV */

int VenusFlush(pname)
char *pname;
{
#ifdef AFS_ENV
    if (ViceIsRunning()) {
	struct ViceIoctl dummy;
	dummy.in_size = 0;
	dummy.out_size = 0;
	return (pioctl(pname, VIOCFLUSH, &dummy, 1));
    } else
#endif /* AFS_ENV */
	return 0;
}

int VenusFlushCallback(pname)
char *pname;
{
#ifdef AFS_ENV
    if (ViceIsRunning()) {
	struct ViceIoctl dummy;
	dummy.in_size = 0;
	dummy.out_size = 0;
	return(pioctl(pname, VIOCFLUSHCB, &dummy, 1));
    } else
#endif /* AFS_ENV */
	return 0;
}

int VenusFetch(pname)
char *pname;
{
#ifdef AFS_ENV
    if (ViceIsRunning()) {
	struct ViceIoctl dummy;
	dummy.in_size = 0;
	dummy.out_size = 0;
	return(pioctl(pname, VIOCPREFETCH, &dummy, 1));
    } else
#endif /* AFS_ENV */
	return 0;
}

int VenusCancelStore(fid)
int fid;
{
#ifdef AFS_ENV
    if (ViceIsRunning()) {
	struct ViceIoctl dummy;
	dummy.in_size = 0;
	dummy.out_size = 0;
	return(ioctl(fid, VIOCABORT, &dummy));
    } else
#endif /* AFS_ENV */
	return 0;
}
