/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/util/lib/RCS/times.c,v 1.20 1993/08/27 21:43:25 gk5g Exp $";
#endif


 

#include <errno.h>
#include <andrewos.h>
#if (!defined(_IBMR2) && !SY_AIXx && !defined(HP300_ENV) && !defined(HP700_ENV) && !defined(HP800_ENV) && !defined(M_UNIX) && (!defined(SGI_4D_ENV)) && !defined(SUN_ENV) && !defined(linux) && !defined(DECOSF_ENV))
extern char *timezone();
#endif /* (!defined(_IBMR2) && !SY_AIXx && !defined(HP300_ENV) && !defined(HP800_ENV)) */

extern int errno;

/* OS independence for times. */
#if SY_AIXx
#define HAS_GETTIMEOFDAY 1
#endif /* #if SY_AIXx */

#ifdef HP300_ENV
#define HAS_GETTIMEOFDAY 1
#endif /* #ifdef HP300_ENV */

#ifdef HP800_ENV
#define HAS_GETTIMEOFDAY 1
#endif /* #ifdef HP800_ENV */

#if SY_B4x
#define HAS_GETTIMEOFDAY 1
#endif /* #if SY_B4x */

#if DECOSF_ENV
#define HAS_GETTIMEOFDAY 1
#endif

int osi_GetTimes(blk)
struct osi_Times *blk;
{
#ifdef HAS_GETTIMEOFDAY
    struct timeval TV;
    int Ret;

    Ret = gettimeofday(&TV, 0);
    blk->Secs = (unsigned int) TV.tv_sec;
    blk->USecs = (unsigned int) TV.tv_usec;
    return (Ret);
#else /* #ifdef HAS_GETTIMEOFDAY */
    blk->Secs = (unsigned int) time(0);
    blk->USecs = 0;
    return (0);
#endif /* #ifdef HAS_GETTIMEOFDAY */
}

#if (SY_AIXx == 0 && SY_U5x == 0)
static int ZonesInitialized = 0;
char *osi_ZoneNames[2];
int osi_SecondsWest;
int osi_IsEverDaylight;

void osi_SetZone()
{
    struct timeval TV;
    struct timezone TZ;
    static char TZ0[20], TZ1[20];
    if (ZonesInitialized == 0) {
	gettimeofday(&TV, &TZ);
	osi_SecondsWest = (int) TZ.tz_minuteswest * 60;
	osi_IsEverDaylight = TZ.tz_dsttime;
	strncpy(TZ0, timezone(TZ.tz_minuteswest, 0), sizeof(TZ0) - 1);
	TZ0[sizeof(TZ0) - 1] = '\0';
	osi_ZoneNames[0] = TZ0;
	strncpy(TZ1, timezone(TZ.tz_minuteswest, 1), sizeof(TZ1) - 1);
	TZ1[sizeof(TZ1) - 1] = '\0';
	osi_ZoneNames[1] = TZ1;
	ZonesInitialized = 1;
    }
}
#endif /* #if (SY_AIXx == 0 && SY_U5x == 0) */

#ifdef TESTINGONLYTESTING
#include <stdio.h>
main() {
    struct osi_Times TMs;
    printf("It's now %ld o'clock; do you know where your children are?\n", osi_GetSecs());
    osi_SetZone();
    printf("Not only that, but this system is %ld seconds (%ld minutes, %ld hours) west of GMT, and %suses Daylight time.\n", osi_SecondsWest, osi_SecondsWest / 60, osi_SecondsWest / (60*60), (osi_IsEverDaylight ? "" : "never "));
    printf("The standard zone name is ``%s''; the daylight zone name is ``%s''.\n", osi_ZoneNames[0], osi_ZoneNames[1]);
    if (osi_GetTimes(&TMs)) {
	printf("osi_GetTimes failed; errno %d\n", errno);
    } else {
	printf("osi_GetTimes returned {%ld, %ld}.\n", TMs.Secs, TMs.USecs);
    }
    exit(0);
}
#endif /* #ifdef TESTINGONLYTESTING */
