/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/util/lib/RCS/getvuid.c,v 2.9 1992/12/15 21:10:10 rr2b R6tape $";
#endif

/* ************************************************************ *\
	getvuid.c
	getvuid() (``get Vice UID'') gets the VUID associated with the ThisDomain authentication.
\* ************************************************************ */

 

#include <andyenv.h>
#include <stdio.h>
#include <errno.h>
#include <andrewos.h>	/* types.h */
#include <svcconf.h>
#include <util.h>

extern int errno;

#ifdef WHITEPAGES_ENV
int getvuid()
{/* Return the Vice UID of the current process, or -1 with errno set */
    struct CellAuth *ca;
    int rc;

    CheckServiceConfiguration();
    if (AMS_ViceIsRunning) {
	rc = FindCell(ThisDomain, &ca);
	if (rc == 0 && ca != NULL) {
	    if (ca->ViceID < 0) FillInCell(ca);
	    if (ca->ViceID >= 0) return ca->ViceID;	/* ViceId in the home cell */
	}
	errno = EINVAL;
	return -1;
    } else {
	return getuid();
    }
}
#endif /* WHITEPAGES_ENV */
