/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/util/lib/RCS/getaddr.c,v 2.8 1992/12/15 21:09:01 rr2b R6tape $";
#endif


 

/* getaddr -- get our internet address */

#include <andrewos.h>		/* types.h */
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <sys/ioctl.h>

#if defined(_IBMR2) && !defined(AF_LINK)
/* For binary compatibility with AIX 3.2... */
#define	AF_LINK		18		/* Link layer interface */
#endif

#define NIFS		6

/* Return our internet address as a int in network byte order.  Returns zero if it can't find one. */
unsigned int getaddr ()
{
    int     s;
    int     i, len;
    struct ifconf   ifc;
    struct ifreq    ifs[NIFS];
    struct sockaddr_in *a;

    s = socket(AF_INET, SOCK_DGRAM, 0);
    if (s < 0)
	return 0;
    ifc.ifc_len = sizeof(ifs);
    ifc.ifc_buf = (caddr_t) ifs;
    i = ioctl(s, SIOCGIFCONF, &ifc);
    close(s);
    if (i < 0)
	return 0;
    len = ifc.ifc_len / sizeof(struct ifreq);
    if (len > NIFS)
	len = NIFS;
    for (i = 0; i < len; ++i) {
	a = (struct sockaddr_in *) &ifs[i].ifr_addr;
#ifdef _IBMR2
	if (a->sin_family == AF_LINK)
	    continue;	/* Skip <link> addresses */
#endif
	if (a->sin_addr.s_addr != 0 && strcmp(ifs[i].ifr_name, "lo0") != 0)
	    return a->sin_addr.s_addr;
    }
    return 0;
}

#ifdef TESTINGONLYTESTING
#include <stdio.h>
#include <arpa/inet.h>
main(argc,argv)
int argc;
char *argv[];
{
  struct in_addr a;

  a.s_addr = getaddr();
  printf("%ul == %s\n", a.s_addr, inet_ntoa(a));
}
#endif /* TESTINGONLYTESTING */
