/* C++ified by magic !@#%&@#$ */
#include <math.h>
#include <atkproto.h>
BEGINCPLUSPLUSPROTOS


/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/
#ifndef MATHAUX_H
#define MATHAUX_H


/* Useful constants */

#define mathaux_PI		M_PI
#define mathaux_E		M_E

#define mathaux_MAXFLOAT	MAXFLOAT
#define mathaux_MAXDOUBLE	
#define mathaux_FLOATEPSILON	(0.0)
#define mathaux_DOUBLEEPSILON	(0.0)
#define mathaux_MAXINT		0x7FFFFFFF
#define mathaux_MININT		0x80000000

#define mathaux_Distance(x1, y1, x2, y2) \
	hypot((x2) - (x1), (y2) - (y1))

#define mathaux_Floor(x) \
	floor(x)

#define mathaux_Ceiling(x) \
	ceil(x)

#define mathaux_Truncate(x) \
	(((x) < 0.0) ? ceil(x) : floor(x))

#define mathaux_Augment(x) \
	(((x) < 0.0) ? floor(x) : ceil(x))

#define mathaux_RoundUp(x) \
	floor((x) + 0.5)

#define mathaux_RoundTowardInfinity(x) \
	(((x) < 0.0) ? ceil((x) - 0.5) : mathaux_RoundUp(x))

#define mathaux_RoundTowardZero(x) \
	(((x) > 0.0) ? ceil((x) - 0.5) : mathaux_RoundUp(x))

#endif

ENDCPLUSPLUSPROTOS
 
