/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/util/cmd/RCS/newbt.c,v 2.14 1993/07/02 14:31:20 rr2b Exp $";
#endif

/* ************************************************************ *\
	newbt.c
	Create a new B-tree of specified desired-node size.
\* ************************************************************ */

#include <andrewos.h> /* strings.h */
#ifdef WHITEPAGES_ENV  /* avoid makedepend "errors" */
#include "bt.h"
#endif /* WHITEPAGES_ENV   */

extern int errno;

static int Debugging = 0;

static char *NewFile;
static int EntrySize;

static void ParseArguments(argc,argv)
int argc;
char *argv[];
{
    int thisarg;
    char *Swch;
    static char *UsageArgs = " [-dDrRwW] FileToCreate EntrySize\n";

    for (thisarg = 1; thisarg < argc && argv[thisarg][0] == '-'; ++thisarg) {
	Swch = &argv[thisarg][1];
	if (strcmp(Swch, "d") == 0) Debugging = 1;
	else if (strcmp(Swch, "D") == 0) Debugging = 2;
	else if (strcmp(Swch, "r") == 0) (void) btr_SetDebugging(1);
	else if (strcmp(Swch, "R") == 0) (void) btr_SetDebugging(2);
	else if (strcmp(Swch, "w") == 0) (void) btw_SetDebugging(1);
	else if (strcmp(Swch, "W") == 0) (void) btw_SetDebugging(2);
	else {
	    fprintf(stdout, "Unrecognized option: ``%s''\nusage: %s%s",
		    argv[thisarg], argv[0], UsageArgs);
	    exit(1);
	}
    }

    if (thisarg < argc) {
	NewFile = argv[thisarg++];
    } else {
	fprintf(stdout, "Missing NewFile argument.\nusage: %s%s", argv[0], UsageArgs);
	exit(2);
    }

    if (thisarg < argc) {
	EntrySize = atoi(argv[thisarg++]);
    } else {
	fprintf(stdout, "Missing NewFile argument.\nusage: %s%s", argv[0], UsageArgs);
	exit(2);
    }

    if (thisarg < argc) {
	fprintf(stdout, "Extra arguments beginning with ``%s'';\nusage: %s%s",
		argv[thisarg], argv[0], UsageArgs);
	exit(3);
    }
}

main(argc, argv)
int argc;
char *argv[];
{
    bt_ErrorCode ErrVal;

    ParseArguments(argc,argv);

    ErrVal = bt_Create(NewFile, EntrySize, btlock_UseFileLock, NULL);
    if (ErrVal == bterr_NoError) {
	fprintf(stdout, "NewBT: File ``%s'' created.\n", NewFile);
	exit(0);
    } else {
	fprintf(stderr, "Error in bt_Create(%s): %s.\n", NewFile,
		bt_ErrorString(ErrVal));
	exit(1);
    }
}

