/* Copyright 1993 Carnegie Mellon University All rights reserved.
  $Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
 */

#include <andrewos.h>
#include <string.h>

/* Define this function here so that this can be compiled before everything else. */
static char *NewString(char *str)
{
    char *result;
    if(str==NULL) return NULL;
    result=(char *)malloc(strlen(str)+1);
    if(result==NULL) return result;
    strcpy(result, str);
    return result;
}
struct dontlist {
    char *path;
    struct dontlist *next;
} *dont=NULL, **lastdont=(&dont);

struct dirlist {
    char *path;
    struct dirlist *next;
} *dirs=NULL, **last=(&dirs);

int AddToDontList(char *path)
{
    struct dontlist *s=dont;
    while(s) {
	if(strcmp(s->path, path)==0) break;
	else s=s->next;
    }
    if(s==NULL) {
	struct dontlist *result=(struct dontlist *)malloc(sizeof(struct dontlist));
	result->path=NewString(path);
	result->next=NULL;
	*lastdont=result;
	lastdont=(&result->next);
	return 1;
    }
    return 0;
}

boolean Dont(char *path)
{
    struct dontlist *s=dont;
    while(s) {
	char *p=strrchr(s->path, '/');
	/* don't do it if it is an exact match. */
	if(strcmp(s->path, path)==0) return TRUE;
	if(p) {
	     /* if the don't path ended in a / don't do any libs in that directory, but do do libs in subdirs. */
	    int len = p-s->path+1;
	    if(p[1]=='\0' && strncmp(s->path, path, len)==0 && strchr(path+len, '/')==NULL) return TRUE;
	} else {
	     /* compare just the last component of the path name to the don't list path */
	    p=strrchr(path, '/');
	    if(p && strcmp(s->path, p+1)==0) return TRUE;
	}
	s=s->next;
    }
    return FALSE;
}	

int AddToDirList(char *path)
{
    struct dirlist *s=dirs;
    while(s) {
	if(strcmp(s->path, path)==0) break;
	else s=s->next;
    }
    if(s==NULL) {
	struct dirlist *result=(struct dirlist *)malloc(sizeof(struct dirlist));
	result->path=NewString(path);
	result->next=NULL;
	*last=result;
	last=(&result->next);
	return 1;
    }
    return 0;
}

char **newargv=NULL;
int size=0;
int newargc=0;

void AddArg(char *arg)
{
    if(newargc>=size) {
	size+=10;
	if(newargv) newargv=(char **)realloc(newargv, size*sizeof(char *));
	else newargv=(char **)malloc(size*sizeof(char *));
    }
    newargv[newargc]=NewString(arg);
    newargc++;
}

char *libext="a";

void ProcessArg(char *arg)
{
    struct dirlist *s=dirs;
    char *p, *q;
    arg=NewString(arg);
    p=strrchr(arg, '.');
    q=strrchr(arg, '/');
    if(p && strcmp(p+1, libext)==0 && q && strncmp(q+1, "lib", 3)==0 && !Dont(arg)) {
	char *n;
	*p='\0';
	*q='\0';
	while(s) {
	    if(strcmp(s->path, arg)==0) {
		n=(char *)malloc(strlen(q+4)+3);
		strcpy(n, "-l");
		strcat(n, q+4);
		AddArg(n);
		free(n);
		free(arg);
		return;
	    }
	    s=s->next;
	}
	n=(char *)malloc(strlen(arg)+3);
	strcpy(n, "-L");
	if(arg[0]) strcat(n, arg);
	else strcat(n, "/");
	if(AddToDirList(arg)) AddArg(n);
	n=(char *)realloc(n, strlen(q+4)+3);
	strcpy(n, "-l");
	strcat(n, q+4);
	AddArg(n);
	free(n);
    } else AddArg(arg);
    free(arg);
}

static void usage() {
    fprintf(stderr, "usage: relativize [directory/ or pathname or libname.a, as many as needed ---] command arguments\n");
    exit(-1);
}

int main(int argc, char **argv)
{
    int i;
    if(argc<2) usage();
    for(i=1;i<=argc-1 && argv[i][0]!='-';i++) {
	AddToDontList(argv[i]);
    }
    if(argv[i][0]=='-' && argv[i][1]=='-' && argv[i][2]=='-') i++;
    if(i>=argc) usage();
    for(;i<=argc-1;i++) {
	if(argv[i][0]=='-') {
	    if(argv[i][1]=='L') {
		if(AddToDirList(argv[i]+2)) AddArg(argv[i]);
		continue;
	    }
	}
	ProcessArg(argv[i]);
    }
    for(i=0;i<newargc;i++) printf("%s%s",newargv[i],i<newargc-1?" ":"");
    printf("\n");
    AddArg(NULL);
    fflush(stdout);
    fflush(stderr);
    execvp(newargv[0], newargv);
    exit(-127);
}
	
