/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/
#ifndef _MALLOC_
#define _MALLOC_
#ifdef ANDREW_MALLOC_ENV
BEGINCPLUSPLUSPROTOS
/* for Sun and system V */
/*
	Constants defining mallopt operations
*/
#define M_MXFAST	1	/* set size of 'small blocks' */
#define M_NLBLKS	2	/* set num of small blocks in holding block */
#define M_GRAIN		3	/* set rounding factor for small blocks */
#define M_KEEP		4	/* (nop) retain contents of freed blocks */

/*
	malloc information structure
*/
struct mallinfo  {
	int arena;	/* total space in arena */
	int ordblks;	/* number of ordinary blocks */
	int smblks;	/* number of small blocks */
	int hblks;  	/* number of holding blocks */
	int hblkhd;	/* space in holding block headers */
	int usmblks;	/* space in small blocks in use */
	int fsmblks;	/* space in free small blocks */
	int uordblks;	/* space in ordinary blocks in use */
	int fordblks;	/* space in free ordinary blocks */
	int keepcost;	/* cost of enabling keep option */

	int mxfast;	/* max size of small blocks */
	int nlblks;	/* number of small blocks in a holding block */
	int grain;	/* small block rounding factor */
	int uordbytes;	/* space (including overhead) allocated in ord. blks */
	int allocated;	/* number of ordinary blocks allocated */
	int treeoverhead;	/* bytes used in maintaining the free tree */
};

/* the following routines are defined by the ITC malloc and do reasonable things */
extern int  	malloc_debug(int  level );
extern int  	malloc_verify();

#define MAXQUEUE 3

struct arenastate {
	struct freehdr *arenastart;	/* point to first block in arena */
	struct freehdr *arenaend;	/* point to the segment trailer for last segment */
	struct freehdr *allocp;	/*free list ptr*/
	int SeqNo;		/* stored by plumber */
	char arenahasbeenreset;	/* 1 after a reset */
	char InProgress;		/* 1 during malloc, realloc, and free */
	char RecurringM0;		/* 1 when recurring due to request too large */
	char MallocStrategy;	/* see below */
	int NQueued;	/* the number of occupied elts in QueuedToFree */
		/* the next field is at the end and is not initialized */
	struct hdr *QueuedToFree[MAXQUEUE];
};

extern int  	CheckAllocs(char *callername);
extern void  	mstats(char *callername);
extern void  	MallocStats(char *callername, FILE *file);
extern void  	resetmstats();
extern int  	(*SetM0Handler(int (*proc)()))();
extern int  	SetMallocCheckLevel(int level );
extern struct arenastate  	*GetMallocArena();
extern void 	NewMallocArena();
extern int  	MallocStrategy(int strategy );
extern void  	plumber(FILE *file );

/* values which can be OR'ed to form MallocStrategy */
#define AllocFront 1
#define DelayAdvance 2
#define AdvanceKludge 4
ENDCPLUSPLUSPROTOS
#endif /* ANDREW_MALLOC_ENV */
#endif /* _MALLOC_ */
